<?php
namespace Ig\IgQrcode\Utility;

use TYPO3\CMS\Core\SingletonInterface;
use DateTime;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class QrLogUtility implements SingletonInterface
{
    public static function log(string $name, string $value, int $sourceId=0, int $targetPageUid=null, int $targetLanguageUid=null): void
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_igqrcode_domain_model_log')->createQueryBuilder();
        $pageUid = $GLOBALS['TSFE']->id;
        $domain = $_SERVER['HTTP_HOST'];
        $queryString = $_SERVER['QUERY_STRING'];
        $uri = $_SERVER['REQUEST_URI'];
        // respect anonymize
        $ip = $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'];
        $now =new DateTime();
        $data = [
            'page_uid' => $pageUid,
            'domain' => $domain,
            'uri' => $uri,
            'ip' => $ip,
            'parameter_name' => $name,
            'parameter_value' => $value,
            'source' => $sourceId,
            'target_page_uid' => $targetPageUid,
            'target_language_uid' => $targetLanguageUid,
            //  'createdate' => $now->format('c'),
            
        ];
        //var_dump($data);exit(0);
        $status = $queryBuilder
                ->insert('tx_igqrcode_domain_model_log')
                ->values($data)
                ->executeStatement();
    }

}
