<?php
namespace Ig\IgQrcode\ViewHelpers;

use Closure;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use Ig\IgQrcode\Utility\QrCodeUtility;

class QrCodeViewHelper  extends AbstractViewHelper
{
    // falls HTML Tages erlaubt sind
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('url', 'string', 'URL for QR-COde', true);
        $this->registerArgument('size', 'int', 'specify module size in dots (pixels).', false, 8);
        $this->registerArgument('level', 'string', 'specify error correction level from L (lowest) to H (highest).', false, 'L');
        $this->registerArgument('width', 'string', 'Image Width', false, null);
        $this->registerArgument('height', 'string', 'Image Height', false, null);
        $this->registerArgument('margin', 'int', 'margin in dots', false);
        $this->registerArgument('micro', 'bool', 'micro', false);
    }
    public static function renderStatic(array $arguments, Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $size = $arguments['size'];
        $level = substr((string) $arguments['level'], 0, 1);
        $width = $arguments['width'];
        $height = $arguments['height'];
        $additionalArguments = [];
        if (isset($arguments['margin'])) {
            $additionalArguments['m'] = (int)$arguments['margin'];
        }
        if (isset($arguments['micro']) && (bool)$arguments['micro']) {
            $additionalArguments['M'] = (int)$arguments['micro'];
        }

        return QrCodeUtility::render($arguments['url'], 'SVG', $additionalArguments, $size, $level, $width, $height);
    }
}



