<?php
namespace Ig\IgQrcode\Widgets;

use Ig\IgQrcode\Widgets\Provider\ChartDataProvider;
use TYPO3\CMS\Dashboard\WidgetApi;
use TYPO3\CMS\Dashboard\Widgets\AdditionalCssInterface;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\EventDataInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Page\JavaScriptModuleInstruction;
use TYPO3\CMS\Dashboard\Widgets\JavaScriptInterface;


class ChartWidget implements WidgetInterface, RequestAwareWidgetInterface, EventDataInterface, AdditionalCssInterface, JavaScriptInterface
{
    /**
     * @var array
     */
    private $chartColor;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly ChartDataProvider $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider,
        private readonly array $options = []
    ) {
    }
    
    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }

    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-qrcode']);

        $view->assignMultiple([
            'options' => $this->options,
            'configuration' => $this->configuration,
        ]);
        return $view->render($this->options['template']);
    }
    
    public function getEventData(): array
    {
        $findByFunc = 'findBy' . ucfirst((string) $this->options['findBy']);
        $chartFunc = $this->options['type'] . 'Chart';

        // check if chart type function is defined
        if (method_exists($this, $chartFunc)) {
            $baseConfig = $this->$chartFunc($findByFunc);
            // check if provider function findBy#### is defined
            if (method_exists($this->dataProvider, $findByFunc)) {
                $baseConfig['graphConfig']['data'] = $this->dataProvider->$findByFunc();
            }
            $baseConfig['graphConfig']['data']['datasets'][0]['label'] = $GLOBALS['LANG']->sL($this->options['label']);
            $baseConfig['graphConfig']['data']['datasets'][0]['backgroundColor'] = $this->chartColors;
            if($this->options['type'] == 'line'){
                $baseConfig['graphConfig']['data']['datasets'][0]['tension'] = 0;
                $baseConfig['graphConfig']['data']['datasets'][0]['fill'] = false;
                $baseConfig['graphConfig']['data']['datasets'][0]['borderColor'] = WidgetApi::getDefaultChartColors()[0];
            }
            return $baseConfig;
        }
    }

    public function lineChart($findBy)
    {
        $this->chartColors = WidgetApi::getDefaultChartColors()[0];
        return [
            'graphConfig' => [
                'type' => 'line',
                'options' => [
                    'maintainAspectRatio' => false,
                    'legend' => [
                        'display' => false,
                    ],
                ],
                'data' => $data,
            ],
        ];
    }

    public function barChart($findBy)
    {
        $this->chartColors = WidgetApi::getDefaultChartColors()[0];
        return [
            'graphConfig' => [
                'type' => 'bar',
                'options' => [
                    'maintainAspectRatio' => false,
                    'legend' => [
                        'display' => false,
                    ],
                    'scales' => [
                        'yAxes' => [
                            [
                                'ticks' => [
                                    'beginAtZero' => true,
                                ],
                            ],
                        ],
                        'xAxes' => [
                            [
                                'ticks' => [
                                    'maxTicksLimit' => 15,
                                ],
                            ],
                        ],
                    ],
                ],
                'data' => $data,
            ],
        ];
    }
    public function doughnutChart($findBy)
    {
        $this->chartColors = WidgetApi::getDefaultChartColors();
        return [
            'graphConfig' => [
                'type' => 'doughnut',
                'options' => [
                    'maintainAspectRatio' => false,
                    'legend' => [
                        'display' => true,
                        'position' => 'bottom',
                    ],
                    'cutoutPercentage' => 60,
                ],
            ],
        ];
    }
    public function getCssFiles(): array
    {
        return ['EXT:dashboard/Resources/Public/Css/Contrib/chart.css'];
    }

    public function getJavaScriptModuleInstructions(): array
    {
        return [
            JavaScriptModuleInstruction::create('@typo3/dashboard/contrib/chartjs.js'),
            JavaScriptModuleInstruction::create('@typo3/dashboard/chart-initializer.js'),
        ];
    }

    public function getOptions(): array
    {
        return $this->options;
    }

}
