<?php

declare (strict_types = 1);


namespace Ig\IgQrcode\Widgets\Provider;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\WidgetApi;
use TYPO3\CMS\Dashboard\Widgets\ChartDataProviderInterface;

/**
 * Provides chart data for sys log errors.
 */
class AbstractSqlDataProvider implements ChartDataProviderInterface
{

    /**
     * @var string
     */
    protected $sql = null;

    /**
     * @var string
     * Default Table: tx_igqrcode_domain_model_log
     */
    protected $tablename = null;
    protected $labelAttribute = 'label';
    protected $dataAttribute = 'data';


    public function getChartData(): array
    {
        if ($this->tablename===null) {
            die('$this->tablename is not defined in ' . static::class);
        }
        if ($this->sql===null) {
            die('$this->sql is not defined in ' . static::class);
        }
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->tablename);
        $statement = $conn->prepare($this->sql);
        $result = $statement->executeQuery();
        while ($row = $result->fetchAssociative()) {
            $labels[] = $row[$this->labelAttribute];
            $data[] = $row[$this->dataAttribute];
        }
        $backgroundColors = array_merge(WidgetApi::getDefaultChartColors(),['#9f973c','#30ba74','#cc8e86','#6b9714','#a081ba','#82385e','#d6e9be','#76b74b','#27928e','#0912d1','#bc5cb4','#9c0449']);
        return [
            'labels' => $labels,
            'datasets' => [
                [
                    'backgroundColor' => $backgroundColors,
                    'border' => 0,
                    'data' => $data,
                ],
            ],
        ];
    }
}
