<?php

declare (strict_types = 1);

namespace Ig\IgQrcode\Widgets\Provider;

use DateTime;
use Internetgalerie\IgWidgets\Utility\CookieUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\WidgetApi;
use TYPO3\CMS\Dashboard\Widgets\ChartDataProviderInterface;

//use TYPO3\CMS\Core\Localization\Locales;

/**
 * Provides chart data for sys log errors.
 */
class DateDataProvider implements ChartDataProviderInterface
{

    /**
     * @var string
     */
    protected $query;

    /**
     * @var string
     * Default Table: tx_igqrcode_domain_model_log
     */
    protected $tablename = 'tx_igqrcode_domain_model_log';

    /**
     * @var string
     */
    protected $dateField = 'createdate';

    /**
     * date format
     *
     * @var string
     */
    protected $dateFormat = '%d.%m.%Y';
    /**
     * date format for sql group by, if null $dateFormat is used
     *
     * @var string
     */
    protected $groupByDateFormat = null;

    /**
     * Number of days to gather information for.
     *
     * @var int
     */
    protected $days = null;

    /**
     * from to date
     *
     * @var string
     */
    protected $cookieFromTo = null;

    /**
     * Fill Date gaps
     *
     * @var string
     */
    protected $fillGaps = '';
    protected $cookieUtility = null;

    public function __construct(int $days = null, string $dateFormat = '%d.%m.%Y', string $groupByDateFormat = null, string $fillGaps = '')
    {
        $this->cookieUtility = GeneralUtility::makeInstance(CookieUtility::class);
        $this->days = $days;
        $this->cookieFromTo = $this->cookieUtility->get('igwidgets_default_from_to') ?? '';
        $this->dateFormat = $dateFormat;
        $this->groupByDateFormat = $groupByDateFormat;
        $this->fillGaps = $fillGaps;
        //\TYPO3\CMS\Extbase\Utility\DebuggerUtility::var_dump($GLOBALS['TYPO3_CONF_VARS']['SYS']['systemLocale']);
        // \TYPO3\CMS\Extbase\Utility\DebuggerUtility::var_dump($this->getChartData());
    }

    public function getChartData(): array
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->tablename);
        $sqlWhere = '';
        if ($this->days > 0 && $this->cookieFromTo == '') {
            $sqlWhere = " WHERE " . $this->dateField . " >= DATE_SUB(CURDATE(), INTERVAL " . $this->days . " Day)";
        } else if ($this->cookieFromTo) {
            $date = explode(' - ', $this->cookieFromTo);
            $from = $date[0];
            $to = $date[1];
            $sqlWhere = " WHERE DATE(createdate) >= '" . $from . "' AND DATE(createdate) <= '" . $to . "' ";
        }
        //echo $sqlWhere;
        $groupByDateFormat = $this->groupByDateFormat ?: $this->dateFormat;
        $this->query = "SELECT DATE_FORMAT(" . $this->dateField . "," . $conn->quote($groupByDateFormat) . ") AS label,COUNT(*) AS data FROM " . $this->tablename . " " . $sqlWhere . "  GROUP BY label ORDER BY label";
        //echo($this->query);
        $statement = $conn->prepare($this->query);
        $result = $statement->executeQuery();
        $locale = $GLOBALS['TYPO3_CONF_VARS']['SYS']['systemLocale'];
        // @todo languageKey to locale
        if ($GLOBALS['BE_USER']->uc['lang'] == 'de') {
            $locale = 'de_DE.utf8';
        }
        $currentLocale = (string) setlocale(LC_TIME, '0');
        setlocale(LC_TIME, $locale);
        // $GLOBALS['TYPO3_CONF_VARS']['SYS']['systemLocale']

        $labels = [];
        $data = [];
        // fill gaps in data Array
        if ($this->fillGaps == 'days' && $this->cookieFromTo == '') {
            $begin = new DateTime('NOW');
            $end = clone $begin;
            $begin->modify('-' . $this->days . ' day');
            $dataDb = [];
            while ($row = $result->fetchAssociative()) {
                $dataDb[$row['label']] = $row['data'];
            }
            for ($date = $begin; $date <= $end; $date->modify('+1 day')) {
                $dataKey = strftime($this->groupByDateFormat, $date->getTimestamp());
                $data[] = $dataDb[$dataKey] ?? 0;
                $labels[] = strftime($this->dateFormat, $date->getTimestamp());
            }
        } else {
            // default return
            while ($row = $result->fetchAssociative()) {
                $labels[] = $this->groupByDateFormat ? strftime($this->dateFormat, strtotime((string) $row['label'])) : $row['label'];
                $data[] = $row['data'];
            }
        }
        setlocale(LC_TIME, $currentLocale);

        return $this->getChartDataReturn($labels, $data);
    }

    public function getChartDataReturn($labels, $data, $count = 1, $innerLabels = ['Views'])
    {
        $chartArray = [
            'labels' => $labels,
            'datasets' => [],
        ];

        $backgroundColors = array_merge(WidgetApi::getDefaultChartColors(), ['#9f973c', '#30ba74', '#cc8e86', '#6b9714', '#a081ba', '#82385e', '#d6e9be', '#76b74b', '#27928e', '#0912d1', '#bc5cb4', '#9c0449']);

        for ($i = 0; $i < $count; $i++) {
            $dataSetArray = [
                'backgroundColor' => $backgroundColors[$i],
                'borderColor' => $backgroundColors[$i],
                'fill' => false,
                'tension' => 0,
                'border' => 0,
                'label' => 'Views', // $this->getLanguageService()->sL('LLL:EXT:dashboard/Re
                'data' => $data,
            ];
            $chartArray['datasets'][] = $dataSetArray;
        }
        return $chartArray;
    }

    public function getLanguageService(): LanguageService
    {
        return $GLOBALS['LANG'];
    }

}
