<?php

declare (strict_types = 1);

namespace Ig\IgQrcode\Widgets\Provider;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Site\SiteFinder;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\WidgetApi;

/**
 * Provides chart data for sys log errors.
 */
class LanguageDataProvider extends AbstractSqlDataProvider
{

    protected $sql =  "SELECT target_language_uid,count(*) AS data FROM tx_igqrcode_domain_model_log WHERE target_language_uid <> '' GROUP BY target_language_uid ORDER BY target_language_uid";
    protected $tablename =  'tx_igqrcode_domain_model_log';
    protected $labelAttribute = 'target_language_uid';

    public function getChartData(): array
    {
        if ($this->tablename===null) {
            die('$this->tablename is not defined in ' . static::class);
        }
        if ($this->sql===null) {
            die('$this->sql is not defined in ' . static::class);
        }
        $finder = GeneralUtility::makeInstance(SiteFinder::class);
        $allSites = $finder->getAllSites();
        $languages = [];
        foreach ($allSites as $site) {
            foreach ($site->getAllLanguages() as $siteLanguage) {                            
                $languageUid = $siteLanguage->getLanguageId();
                $languages[$languageUid] = $siteLanguage->getTitle();
            }
        }
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->tablename);
        $statement = $conn->prepare($this->sql);
        $result = $statement->executeQuery();
        $languageUids = [];
        while ($row = $result->fetchAssociative()) {
            $languageUids[] = $row[$this->labelAttribute];
            $data[] = $row[$this->dataAttribute];
        }
        foreach ($languageUids as $languageUid) {
            $labels[]= $languages[$languageUid];
        }
        $backgroundColors = array_merge(WidgetApi::getDefaultChartColors(),['#9f973c','#30ba74','#cc8e86','#6b9714','#a081ba','#82385e','#d6e9be','#76b74b','#27928e','#0912d1','#bc5cb4','#9c0449']);
        return [
            'labels' => $labels,
            'datasets' => [
                [
                    'backgroundColor' => $backgroundColors,
                    'border' => 0,
                    'data' => $data,
                ],
            ],
        ];
    }
    
}
