<?php
declare (strict_types = 1);

namespace Ig\IgQrcode\Widgets\Provider;

use Internetgalerie\IgWidgets\Utility\CookieUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class TableProvider
{
    /**
     * @var int
     */
    private $limit;
    /**
     * @var string
     */
    protected $query;
    /**
     * @var string
     * Default Table: tx_igqrcode_domain_model_log
     */
    protected $table = 'tx_igqrcode_domain_model_log';

    /**
     * @var string
     */
    protected $labelTable = 'tx_igcontentservbase_domain_model_pimview';
    protected $cookieUtility = null;
    protected $cookieFabric = '';

    public function __construct(int $limit)
    {
        $this->limit = $limit ?: 10;
        $this->cookieUtility = GeneralUtility::makeInstance(CookieUtility::class);
        // set igwidgets_Fabric cookie
        $this->cookieUtility->set('Fabric');

        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->table);
        $schemaManager = $conn->createSchemaManager();
        $this->labelTableExists = $schemaManager->tablesExist([$this->labelTable]);
            

        if ($this->labelTableExists) {
            // get Fabric labels
            $this->query = "SELECT label FROM tx_igqrcode_domain_model_log JOIN " . $this->labelTable . " AS P ON P.id = parameter_value WHERE parameter_value <> '' AND P.sys_language_uid = 0 GROUP BY parameter_value ORDER BY label";
        } else {
            $this->query = "SELECT parameter_value AS label FROM tx_igqrcode_domain_model_log GROUP BY parameter_value ORDER BY label";
        }
        $selectValues[0] = '';
        foreach ($this->getData() as $key => $value) {
            $selectValues[] = $value['label'];
        }
        // give igwidgets_Fabric a type and select options
        $this->cookieUtility->set('Fabric_conf', ['type' => 'select', 'values' => $selectValues]);
        // get igwidgets_Fabric cookie value
        $this->cookieFabric = $this->cookieUtility->get('Fabric') ?? '';
        // get igwidgets_default_from_to(default cookie) cookie value
        $this->cookieFromTo = $this->cookieUtility->get('igwidgets_default_from_to') ?? '';
    }

    public function findByAll(): array
    {
        $where = '';
        $whereArray = [];
        if ($this->cookieFabric) {
            $whereArray[] = " label = '" . $this->cookieUtility->get('Fabric') . "'";
        }
        if ($this->cookieFromTo) {
            $date = explode(' - ', $this->cookieFromTo);
            $from = $date[0];
            $to = $date[1];
            $whereArray[] = " DATE(createdate) >= '" . $from . "' AND DATE(createdate) <= '" . $to . "' ";
        }
        if ($this->cookieFabric || $this->cookieFromTo) {
            $where = "WHERE " . implode(' AND ', $whereArray);
        }

        if ($this->labelTableExists) {
            $this->query = 'SELECT COALESCE(label,parameter_value,uri) AS stoff,createdate AS datum, L.title AS sprache FROM tx_igqrcode_domain_model_log LEFT OUTER JOIN ' . $this->labelTable . ' AS P ON P.id = parameter_value AND P.sys_language_uid = 0 LEFT OUTER JOIN sys_language AS L ON L.uid = target_language_uid ' . $where . ' ORDER BY createdate DESC limit 100';
        } else {
            $this->query = 'SELECT  COALESCE(parameter_value,uri) AS stoff,createdate AS datum, null AS sprache FROM tx_igqrcode_domain_model_log ORDER BY createdate DESC limit 100';
        }
        return $this->getData();
    }

    public function findByFabric(): array
    {
        $where = " parameter_value <> '' ";
        if ($this->cookieFabric) {
            $where .= " AND label = '" . $this->cookieUtility->get('Fabric') . "'";
        }
        if ($this->labelTableExists) {
            $where .= " AND P.sys_language_uid = 0";
            $this->query = 'SELECT label,count(*) AS total FROM tx_igqrcode_domain_model_log JOIN ' . $this->labelTable . ' AS P ON P.id = parameter_value WHERE ' . $where . ' GROUP BY parameter_value ORDER BY count(*) DESC,label';
        } else {
            $this->query = 'SELECT parameter_value AS label,count(*) AS total FROM tx_igqrcode_domain_model_log WHERE ' . $where . ' GROUP BY parameter_value ORDER BY count(*) DESC,label';
        }
        return $this->getData();
    }

    public function getData(): array
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->table);
        $statement = $conn->prepare($this->query);
        $result = $statement->executeQuery();
        return $result->fetchAllAssociative();
    }

}
