<?php
namespace Ig\IgQrcode\Widgets;

use Ig\IgQrcode\Widgets\Provider\TableProvider;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;

class TableWidget implements WidgetInterface, RequestAwareWidgetInterface
{

    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly TableProvider $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }
    
    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-qrcode']);


        $findBy = 'findBy' . ucfirst((string) $this->options['findBy']);
        if (method_exists($this->dataProvider, $findBy)) {
            $view->assignMultiple([
                'columns' => array_map('trim', explode(',', (string) $this->options['columns'])),
                'records' => $this->dataProvider->$findBy(),
                'options' => $this->options,
                'configuration' => $this->configuration,
            ]);
            return $view->render($this->options['template']);
        }
    }
    public function getOptions(): array
    {
        return $this->options;
    }

}
