<?php

namespace Internetgalerie\IgRecurrenceDate\Utility;


class TcaUtility {

    /**
     * Get recurrence configuration for a specific table
     */
    static public function getRecurrenceConfigForTable(string $tableName): array
    {
        if (!isset($GLOBALS['TCA'][$tableName]['columns'])) {
            return [];
        }
        foreach ($GLOBALS['TCA'][$tableName]['columns'] as $fieldName => $fieldConfig) {
            if (($fieldConfig['config']['renderType'] ?? '') === 'recurrence') {
                $config = $fieldConfig['config'];
                return [
                    'eventTable' =>  $tableName,
                    'eventTableLabel' => $GLOBALS['TCA'][$tableName]['ctrl']['label'],
                    'eventTableMainDateAttribute' =>  $config['mainDateAttribute'] ?? 'date_from',
                    'eventTableAdditionalDateAttributes' =>  $config['additionalDateAttributes'] ?? [],
                    'eventTableEventgroupAttribute' =>  $fieldName,
                    'eventgroupTable' =>  $config['foreign_table'] ?? 'tx_igrecurrencedate_domain_model_eventgroup',
                    'registrationTable' =>  $config['registration_table'] ?? '',
                    'registrationTableMatchField' =>  $config['registration_table_match_field'] ?? 'uid_foreign',
                ];
            }
        }
        return [];
    }
}