<?php

namespace Internetgalerie\IgRecurrenceDate\Utility;

use DateTime;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class JsonUtility
{
    public static function getJsonForProperties($properties)
    {
        $json = [];

        $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');

        foreach ($properties as $propertyName => $value) {
            if (!is_object($value)) {
                $json[$propertyName] = $value;
            } elseif ($value instanceof DateTime) {
                $json[$propertyName] = $value->format('Y-m-d H:i:s');
            } elseif ($value instanceof ObjectStorage || is_array($value)) {
                $data = [];
                foreach ($value as $v) {
                    if ($v instanceof FileReference) {
                        $data[] = [
                            'file' => rtrim(
                                (string) $site->getConfiguration()['base'],
                                '/'
                            ) . $v->getOriginalResource()->getPublicUrl(),
                            'extension' => $v->getOriginalResource()
->getExtension(),
                            'size' => $v->getOriginalResource()
->getSize(),
                        ];
                    } elseif (method_exists($v, 'getJson')) {
                        $data[] = $v->getJson();
                    } else {
                        $data[] = $v->getUid();
                    }
                }
                $json[$propertyName] = $data;
            } elseif (is_object($value)) {
                if ($value instanceof FileReference) {
                    $data[] = [
                        'file' => rtrim(
                            (string) $site->getConfiguration()['base'],
                            '/'
                        ) . $value->getOriginalResource()->getPublicUrl(),
                        'extension' => $value->getOriginalResource()
->getExtension(),
                        'size' => $value->getOriginalResource()
->getSize(),
                    ];
                } elseif (method_exists($value, 'getJson')) {
                    $json[$propertyName] = $value->getJson();
                } else {
                    $json[$propertyName] = $value->getUid();
                }
            }
        }

        return $json;
    }
}
