<?php

namespace Internetgalerie\IgRecurrenceDate\Domain\Repository;

use DateTime;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Eventgroups
 */
class EventgroupRepository extends Repository
{
    public function findCurrent()
    {
        $query = $this -> createQuery();
        $now = new DateTime();
    
        $query->matching(
            $query->logicalAnd(
                $query->logicalOr(
                    $query->equals('repeatTill', null),
                    $query->equals('repeatTill', '0000-00-00'),
                    $query->greaterThanOrEqual('repeatTill', $now)
                ),
                $query->logicalOr($query->greaterThanOrEqual('firstDate', $now), $query->equals('repeated', true))
                //					    $query->greaterThan('events',0)
            )
        );
    
        return $query->execute();
    }
}
