<?php

namespace Internetgalerie\IgRecurrenceDate\ViewHelpers;

use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class IsExcludeDateViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        $this->registerArgument('eventgroup', 'int', 'uid of eventgroup', true);
        $this->registerArgument('date', 'string', 'date string Y-m-d to check in exclude dates', true);
    }

    public function render()
    {
        $uid = $this->arguments['eventgroup'];
        $date = $this->arguments['date'];

        $tableName = 'tx_igrecurrencedate_domain_model_eventgroup';
        //SELECT recurrence_exclude_dates FROM tx_igrecurrencedate_domain_model_eventgroup WHERE uid 0 XX AND JSON_CONTAINS(recurrence_exclude_dates, '"2025-02-04"');
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($tableName);
        $row = $queryBuilder
            ->select('uid')
            ->from($tableName)
            ->where(
                $queryBuilder->expr()
->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)),
                'JSON_CONTAINS(recurrence_exclude_dates,' . $queryBuilder->createNamedParameter(
                    '"' . $date . '"',
                    Connection::PARAM_STR
                ) . ')'
            )
            ->executeQuery()
            ->fetchAssociative();

        return is_array($row);
    }
}
