<?php
namespace Internetgalerie\IgRender\ViewHelpers\Render;

/**
 * Daniel Abplanalp: Primitiver FlowViewHelper
 * Same usage
 * @see line 52
 */
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class FlowViewHelper extends \TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper
{
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this -> registerArgument('lineWidth', 'integer', 'Raster width of the Flow Line', false, '4');
        $this -> registerArgument('lineHeight', 'integer', 'Raster height of the Flow Line', false, '2');
        $this -> registerArgument('lineHeightMode', 'string', 'Raster height mode: (auto,fix,firstElement)', false, 'auto');
        $this -> registerArgument('propertyWidth', 'string', 'Property of object to get the width', false);
        $this -> registerArgument('propertyHeight', 'string', 'Property of object to get the height', false);
        $this -> registerArgument('propertyDimension', 'string', 'Property of object to get the width x height', false);
        $this -> registerArgument('dimensionSeperator', 'string', 'seperator of dimenstion value to get the width x height', false, 'x');
    }

    /**
       * @param array $arguments
       * @param \Closure $renderChildrenClosure
       * @param RenderingContextInterface $renderingContext
       * @return string
       * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
       */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $templateVariableContainer = $renderingContext->getVariableProvider();
        if ($arguments['each'] === null) {
            return '';
        }
        if (is_object($arguments['each']) && !$arguments['each'] instanceof \Traversable) {
            throw new \TYPO3\CMS\Fluid\Core\ViewHelper\Exception('FluidViewHelper only supports arrays and objects implementing \Traversable interface', 1248728393);
        }

        if ($arguments['reverse'] === true) {
            // array_reverse only supports arrays
            if (is_object($arguments['each'])) {
                $arguments['each'] = iterator_to_array($arguments['each']);
            }
            $arguments['each'] = array_reverse($arguments['each']);
        }
        $iterationData = array('index' => 0, 'cycle' => 1, 'total' => count($arguments['each']));

        $output = '';
        $igFlow = new \Internetgalerie\IgRender\Utility\IgFlow();
        if ($arguments['lineWidth']) {
            $igFlow->setLineWidth($arguments['lineWidth']);
        }
        if ($arguments['lineHeight']) {
            $igFlow->setLineHeight($arguments['lineHeight']);
        }
        if ($arguments['lineHeightMode']=='fix') {
            $lineHeightMode=$igFlow::$LineHeightMode_FIX;
        } elseif ($arguments['lineHeightMode']=='firstElement') {
            $lineHeightMode=$igFlow::$LineHeightMode_FIRST_ELEMENT;
        } elseif ($arguments['lineHeightMode']=='auto' || !$arguments['lineHeightMode']) {
            $lineHeightMode=$igFlow::$LineHeightMode_AUTO;
        } else {
            return 'wrong lineHeightMode "'.$$arguments['lineHeightMode'].'"';
        }
        $igFlow->setLineHeightMode($lineHeightMode);

    
        $useMethodWidthHeight=false;
        if ($arguments['propertyWidth']) {
            $useMethodWidthHeight=true;
            $methodWidth='get' .ucfirst($arguments['propertyWidth']);
            $methodHeight='get' .ucfirst($arguments['propertyHeight']);
        } elseif ($arguments['propertyDimension']) {
            $methodDimension='get' .ucfirst($arguments['propertyDimension']);
        } else {
            return 'Error in FlowViewHelper: No Property for width and height (Hint: use propertyWidth and propertyHeight or propertyDimension)';
        }
        
    
        foreach ($arguments['each'] as $keyValue => $entry) {
            if (is_array($entry)) {
                // Array
                if ($useMethodWidthHeight) {
                    $w =  $entry[$arguments['propertyWidth']] ? : 1;
                    $h = $entry[$arguments['propertyHeight']] ? : 1;
                } else {
                    $dimension = explode($arguments['dimensionSeperator'], $entry[$arguments['propertyDimension']]);
          
                    $w = $dimension[0] ?? 1;
                    $h = $dimension[1] ?? 1;
                }
            } else {
                // Object
                if ($useMethodWidthHeight) {
                    if (!method_exists($entry, $methodWidth)) {
                        return 'Error in FlowViewHelper: For Property "' . $arguments['propertyWidth']. '" function "'.$methodWidth.'" not exists';
                    }
                    if (!method_exists($entry, $methodHeight)) {
                        return 'Error in FlowViewHelper: For Property "' . $arguments['propertyHeight']. '" function "'.$methodHeight.'" not exists';
                    }
                    $w = $entry->{$methodWidth}();
                    $h = $entry->{$methodHeight}();
                } else {
                    if (!method_exists($entry, $methodDimension)) {
                        return 'Error in FlowViewHelper: For Property "' . $arguments['propertyDimension']. '" function "'.$methodDimension.'" not exists';
                    }
                    $dimension = explode($arguments['dimensionSeperator'], $entry->{$methodDimension}());

                    $w = $dimension[0] ?? 1;
                    $h = $dimension[1] ?? 1;
                }
            }
            if ($w<1) {
                $w=1;
            }
            if ($h<1) {
                $h=1;
            }
            $igFlow->add($entry, $w, $h);
        }
        foreach ($igFlow->getLines() as $lineNr=>$line) {
            $output.='<div class="ig-flow-line ig-flow-line-height-'.$line['height'].' ig-flow-line-width-'.$igFlow->getLineWidth().'">';
            foreach ($line['rows'] as $rowNr=>$row) {
                $output.='<div class="ig-flow-row ig-flow-row-'.$row['width'].'">';
                foreach ($row['entries'] as $xy=>$entry) {
                    $output.='<div class="'.$entry['css'].'"><div>';
                    $singleElement=$entry['object'];
                    $templateVariableContainer -> add($arguments['as'], $singleElement);
                    if ($arguments['key'] !== '') {
                        $templateVariableContainer -> add($arguments['key'], $keyValue);
                    }
                    if ($arguments['iteration'] !== null) {
                        $iterationData['isFirst'] = $iterationData['cycle'] === 1;
                        $iterationData['isLast'] = $iterationData['cycle'] === $iterationData['total'];
                        $iterationData['isEven'] = $iterationData['cycle'] % 2 === 0;
                        $iterationData['isOdd'] = !$iterationData['isEven'];
                        $templateVariableContainer -> add($arguments['iteration'], $iterationData);
                        $iterationData['index']++;
                        $iterationData['cycle']++;
                    }
          
                    // EDIT MB:
                    // IG - TODO: Hook integrieren -> Bildbreiten ändern
                    if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('ig_responsive_images')) {
                        $responsiveImageUtility=GeneralUtility::makeInstance('Ig\IgResponsiveImages\Utility\ResponsiveImagesUtility');
                        //echo('width='.$row['width'] .','.$igFlow->getLineWidth() .'='.round($row['width']/$igFlow->getLineWidth()*100,1) );
        $responsiveImageUtility->pushClass('igFlow-'.$igFlow->getLineWidth() . '-' . $entry['width']); // $row['width']
        $output .= trim($renderChildrenClosure());
                        //$className='igFlow-'.$igFlow->getLineWidth() . '-' . $entry['width'];
                        //$output .= '[[['.$className .' :: START=='.$responsiveImageUtility->getSizes().']]]'.trim($renderChildrenClosure()).'[[[END: '.$responsiveImageUtility->getSizes().']]]';
                        $responsiveImageUtility->popClass();
                    } else {
                        $output .= trim($renderChildrenClosure());
                    }
                    // END EDIT MB
          
                    $templateVariableContainer -> remove($arguments['as']);
                    if ($arguments['key'] !== '') {
                        $templateVariableContainer -> remove($arguments['key']);
                    }
                    if ($arguments['iteration'] !== null) {
                        $templateVariableContainer -> remove($arguments['iteration']);
                    }
                    $output.='</div></div>';
                }
                $output.='</div>';
            }
            $output.='</div>';
        }
        return $output;
    }
}
