            function adjustSliderAspect() {
                $('.ig-slider').each(function() {
                   // Check for the aspect ratio
                   var aspect = $(this).data('aspect');
                   if(!aspect || aspect == 'aspect-spezial') {
                       return;
                   }

                   var numberOfSlides = $(this).data('numberOfSlides');
                   if(numberOfSlides > 2 && $(window).outerWidth() < 851) {
                       numberOfSlides = 2;
                   }
                   if($(window).outerWidth() < 451) {
                       numberOfSlides = 1;
                   }

                   // Calculate the aspect ratio as a floating point number
                   var aspectRatio = $(this).data('aspect').substring(6);
                   aspectRatio = aspectRatio.split('-');
                   aspectRatio = aspectRatio[1] / aspectRatio[0];

                   // Calculate the width and height based on the aspect ratio
                   var width = $(this).width() / numberOfSlides;
                   var height = width * aspectRatio;

                   // Need to set max-height so the slider doesn't jump around,
                   // because slick sometimes sets its own height for a short
                   // moment.
                   $(this).css('max-height', height + 'px');
                   $(this).height(height);

                   // Set the height on the slides aswell.
                   $(this).find('.slick-slide img').height(height);
               });
            }


            adjustSliderAspect();
            $(window).smartresize(function() {
                adjustSliderAspect();
            });

            $(window).on('load', function() {
		$('.slick-slide').show();
            });
