<?php
declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace Internetgalerie\IgRender\MetaTag;

use TYPO3\CMS\Core\MetaTag\MetaTagManagerRegistry;
use TYPO3\CMS\Core\Resource\FileReference;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Frontend\Resource\FileCollector;

/**
 * Class to add the metatags for the SEO fields in core
 *
 * @internal
 */
class MetaTagGenerator extends \TYPO3\CMS\Seo\MetaTag\MetaTagGenerator
{
    /**
     * Generate the meta tags that can be set in backend and add them to frontend by using the MetaTag API
     *
     * @param array $params
     */
    public function generate(array $params)
    {
        parent::generate($params);

        $configurationManager = GeneralUtility::makeInstance(ConfigurationManager::class);
        $settings = $configurationManager->getConfiguration(ConfigurationManager::CONFIGURATION_TYPE_FRAMEWORK, 'IgRender')['settings'];

        if (!empty($params['page']['media']) && $settings['social_image_pagemedia']) {
            $fileCollector = GeneralUtility::makeInstance(FileCollector::class);
            $fileCollector->addFilesFromRelation('pages', 'media', $params['page']);
            $files = $fileCollector->getFiles();

            if(!empty($files)) {
                // Function "generateSocialImages" is for arrays and returns an array but we will only need it for the first image
                $socialImages = $this->generateSocialImages([$files[0]]);

                if(!empty($socialImages)) {
                    $socialImage = $socialImages[0];
                    $subPropertiesTwitter = [];

                    if (!empty($socialImage['alternative'])) {
                        $subPropertiesTwitter['alt'] = $socialImage['alternative'];
                    }

                    $subPropertiesOg = $subPropertiesTwitter;
                    $subPropertiesOg['url'] = $socialImage['url'];
                    $subPropertiesOg['width'] = $socialImage['width'];
                    $subPropertiesOg['height'] = $socialImage['height'];

                    $metaTagManagerRegistry = GeneralUtility::makeInstance(MetaTagManagerRegistry::class);

                    $managerOg = $metaTagManagerRegistry->getManagerForProperty('og:image');
                    $managerOg->addProperty(
                        'og:image',
                        $socialImage['url'],
                        $subPropertiesOg
                    );

                    $managerTwitter = $metaTagManagerRegistry->getManagerForProperty('twitter:image');
                    $managerTwitter->addProperty(
                        'twitter:image',
                        $socialImage['url'],
                        $subPropertiesTwitter
                    );
                }
            }
        }
    }
}
