<?php
namespace Internetgalerie\IgRender\ViewHelpers\Condition\String;


use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

/**
 * ### Condition: String starts with a given substring
 *
 * Condition ViewHelper which renders the `then` child if provided
 * Performs a case-sensitive check indicating if $haystack begins with $needle. 
 */
class StartsWithViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('haystack', 'string', 'haystack', true);
        $this->registerArgument('needle', 'string', 'need', true);
    }

    /**
     * @param array $arguments
     * @return bool
     */
    protected static function evaluateCondition($arguments = null)
    {
        return substr($arguments['haystack'], 0, strlen($arguments['needle'])) == $arguments['needle'];
        //return str_starts_with($arguments['haystack'], $arguments['needle']);
    }
}
