<?php

namespace Internetgalerie\IgRender\ViewHelpers\Slider;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class ForViewHelper extends \TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper
{
    /**
     * The configuration for the slider. It uses the configuration defined in the
     * main slider ViewHelper.
     *
     * @var array
     */

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('classname', 'string', 'Classname - should be unique', false);
        $this->registerArgument('class', 'string', 'Class', false, '');
        $this->registerArgument('settings', 'array', 'settings - as array see https://kenwheeler.github.io/slick/#settings', false, []);
        $this->registerArgument('settingsJs', 'array', 'settings - as array see https://kenwheeler.github.io/slick/#settings', false, []);
        $this->registerArgument('config', 'string', 'Slider Cofig: slick,lightslider', false, 'slick');
        $this->registerArgument('aspect', 'string', 'Aspect String', false, '16-9');
        $this->registerArgument('fade', 'boolean', 'fade on/off', false);
        $this->registerArgument('swipe', 'boolean', 'swipe on/off', false);
        $this->registerArgument('slidesToShow', 'int', 'slide to show', false, 1);
        $this->registerArgument('initialSlide', 'string', 'slide to start', false, '0');
        $this->registerArgument('autoplay', 'boolean', 'autoplay on/off', false);
        $this->registerArgument('autoplaySpeed', 'string', 'autoplaySpeed in ms', false);
        $this->registerArgument('autoplaySpeedSec', 'string', 'autoplaySpeed in Sekunden', false);
        $this->registerArgument('speed', 'string', 'speed in ms', false);
        $this->registerArgument('speedSec', 'string', 'speed in Sekunden', false);
        $this->registerArgument('random', 'bool', 'Random image order', false);
        $this->registerArgument('randomFirst', 'bool', 'Choose random first image', false);
        $this->registerArgument('slidesAmount', 'int', 'The amound of slides there are', false);
        $this->registerArgument('useAutoplayToggleButton', 'bool', 'Controls whether a pause/play icon button is added when autoplay is enabled. Setting this to false without providing an alternative control would likely violate WCAG 2.2.2, so be careful!', false, false);
        $this->registerArgument('useArrows', 'bool', 'Enable Next/Prev arrows', false, false);
        $this->registerArgument('useDots', 'bool', 'Enable dots', false, false);
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return string
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $templateVariableContainer = $renderingContext->getVariableProvider();
        //  $templateVariableContainer = $renderingContext->getTemplateVariableContainer();
        if ($arguments['each'] === null) {
            return '';
        }
        if (is_object($arguments['each']) && !$arguments['each'] instanceof \Traversable) {
            throw new \TYPO3\CMS\Fluid\Core\ViewHelper\Exception('ForViewHelper only supports arrays and objects implementing \Traversable interface', 1248728393);
        }


        $selectedConfig = \Internetgalerie\IgRender\Utility\SliderConfigUtility::get($arguments);


        if ($arguments['reverse'] === true) {
            // array_reverse only supports arrays
            if (is_object($arguments['each'])) {
                $arguments['each'] = iterator_to_array($arguments['each']);
            }
            $arguments['each'] = array_reverse($arguments['each']);
        }
        $iterationData = array(
            'index' => 0,
            'cycle' => 1,
            'total' => count($arguments['each'])
        );

        $output = '';
        $sliderIndex = 0;
        $initialSlide = $arguments['initialSlide'];
        // check initialSlide for allowed values
        $initialSlide = \Internetgalerie\IgRender\Utility\SliderConfigUtility::checkInitialSlide($initialSlide);
        $slidesToShow = $arguments['slidesToShow'];

        foreach ($arguments['each'] as $keyValue => $singleElement) {
            // is Slide initial shown on desktop
            $initialshow = $sliderIndex >= (int) $initialSlide && $sliderIndex < $slidesToShow + (int) $initialSlide;

            $templateVariableContainer->add($arguments['as'], $singleElement);
            if ($arguments['key'] !== '') {
                $templateVariableContainer->add($arguments['key'], $keyValue);
            }
            if ($arguments['iteration'] !== null) {
                $iterationData['isFirst'] = $iterationData['cycle'] === 1;
                $iterationData['isLast'] = $iterationData['cycle'] === $iterationData['total'];
                $iterationData['isEven'] = $iterationData['cycle'] % 2 === 0;
                $iterationData['isOdd'] = !$iterationData['isEven'];
                $templateVariableContainer->add($arguments['iteration'], $iterationData);
                $iterationData['index']++;
                $iterationData['cycle']++;
            }

            $childContent = trim($renderChildrenClosure());

            // ($hideSlide ? 'style="display: none;"' : '') . 
            $output .= $childContent ? '<' . $selectedConfig['slideTag'] . ' class="splide__slide ig-slider-slide ig-slider-slide-' . $sliderIndex . ' ' . ($initialshow ? 'ig-slider-show-onload ig-slider-slide-initial-show' : 'ig-slider-slide-initial-hide') . '" data-splide-index="slide' . $sliderIndex . '" data-splide-hash="slide' . $sliderIndex . '">' . $childContent . '</' . $selectedConfig['slideTag'] . '>' : '';

            //$output .= $childContent;
            $templateVariableContainer->remove($arguments['as']);
            if ($arguments['key'] !== '') {
                $templateVariableContainer->remove($arguments['key']);
            }
            if ($arguments['iteration'] !== null) {
                $templateVariableContainer->remove($arguments['iteration']);
            }
            $sliderIndex++;
        }

        if ($output) {
            $data = 'data-settings="' . htmlspecialchars(json_encode($selectedConfig['dataSettings'])) . '"';
            $data .= ' data-number-of-slides="' . $slidesToShow . '"';
            if ($arguments['aspect']) {
                $data .= ' data-aspect="' . $arguments['aspect'] . '"';
            }
            return '<' . $selectedConfig['sliderTag'] . ' class="splide ig-splide-slider ig-slider ig-slider-' . $slidesToShow . '-slides-to-show ig-slider-onload ' . $selectedConfig['classname'] . ($arguments['class'] ? ' ' . $arguments['class'] : '') . '" ' . $data . '>' . $selectedConfig['slideContainerStart'] . $output . $selectedConfig['slideContainerStop'] . '</' . $selectedConfig['sliderTag'] . '>';
        } else {
            return '';
        }
    }
}
