<?php
namespace Internetgalerie\IgRender\ViewHelpers\Slider;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * Slide in Slider
 */
class SlideViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments()
    {
        $this -> registerArgument('class', 'string', 'CSS class', false);
        $this -> registerArgument('thumb', 'string', 'Slider Config: slick,lightslider', false);
        $this -> registerArgument('src', 'string', 'Slider Config: slick,lightslider', false);
        $this -> registerArgument('hash', 'string', 'hash string for #hash, to initial select slide', false);
        $this -> registerArgument('show', 'boolean', 'Show slider otherwise hidden', false, null);
        $this->registerArgument('style', 'string', 'Slider Style', false, null);
    }

    public function render(): string
    {
        $arguments = $this->arguments;
        $output = '';
        $slideTag='div';
        $dataTag='';
        $additionalClass = '';
	$selectedConfig = \Internetgalerie\IgRender\Utility\SliderConfigUtility::get($arguments);
	$display = '';

        if ($selectedConfig) {
            $slideTag = $selectedConfig['slideTag'];
        }
        if ($arguments['thumb']) {
            $dataTag.=' data-thumb="'.$arguments['thumb'].'"';
        }
        if ($arguments['src']) {
            $dataTag.=' data-src="'.$arguments['src'].'"';
        }
        if ($arguments['class']) {
            $additionalClass.=' '.$arguments['class'];
        }
        $sliderIndex = 0;
        $slidesToShow = 1;
        $initialSlide = 0;
        $viewHelperVariableContainer = $this->renderingContext->getViewHelperVariableContainer();
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex')) {
            $sliderIndex = (int)$viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex');
        }
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow')) {
            $slidesToShow = (int)$viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'slidesToShow');
        }
        if ($viewHelperVariableContainer->exists(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide')) {
            $initialSlide= $viewHelperVariableContainer->get(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'initialSlide');
        }
        $dataTag .= ' data-splide-index="slide' . $sliderIndex . '" data-splide-hash="slide' . $sliderIndex . '"';

        if ($arguments['hash']) {
            $dataTag.=' data-hash="' . $arguments['hash'] . '"';
            $dataTag.=' data-index="' . $sliderIndex . '"';
        }

        if ($arguments['show'] === null) {
            $initialshow = $sliderIndex >= (int) $initialSlide && $sliderIndex< $slidesToShow + (int) $initialSlide;

        } else {
            $notShow = (int) $arguments['show'] ==0 && strtolower($arguments['show'])!=='true';
            $display = $notShow ? ' style="display: none;"': '';
            $initialshow =  !$notShow;
        }
        // is Slide initial shown on desktop

        $output .=  '<' . $slideTag . ' class="ig-slider-slide splide__slide ig-slider-slide-' . $sliderIndex . ' ' . ($initialshow ? 'ig-slider-slide-initial-show' : 'ig-slider-slide-initial-hide')  . ' ' . $additionalClass . '"' . $dataTag . $display . '>' . $this->renderChildren() . '</' . $slideTag . '>';

        $sliderIndex++;
        $viewHelperVariableContainer->addOrUpdate(\Internetgalerie\IgRender\ViewHelpers\SliderViewHelper::class, 'sliderIndex', $sliderIndex);
        

        return $output;
    }
}
