<?php
namespace Internetgalerie\IgRender\ViewHelpers\FrontendUser;

use Internetgalerie\IgRender\Utility\UnCacheUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * get the username of the current frontend user
 **/
class UsernameViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
  {
      $cache = GeneralUtility::makeInstance(UnCacheUtility::class);
      return $cache->registerAspect('frontend.user', 'username', '');
    }
}
