<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;


/**
 * @todo is not working in TYPO3 9.5 an highter - due to cache
 * get the user object of the current frontend user 
 **/
class FrontendUserViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    public function initializeArguments()
    {
        $this->registerArgument('as', 'string', 'Name for the frontendUser object', false, 'frontendUser');
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
  {
      $frontendUser = $GLOBALS['TSFE']->fe_user->user;
      
      $templateVariableContainer=$renderingContext->getVariableProvider();
      $templateVariableContainer->add($arguments['as'], $frontendUser);
      $content = $renderChildrenClosure();
      $templateVariableContainer->remove($arguments['as']);
      return $content;
    }
}
