<?php
namespace Internetgalerie\IgRender\ViewHelpers\Container;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Service\FlexFormService;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class FlexformViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;


    public function initializeArguments()
    {
        $this->registerArgument('xml', 'string', '', false);
        $this->registerArgument('as', 'string', '', false, 'flexform');
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
  {

      
      $flexformArray = GeneralUtility::makeInstance(FlexFormService::class)->convertFlexFormContentToArray($arguments['xml']);
      // add argument to select full or 1 dimension array
      //$flexformArray = GeneralUtility::xml2array($arguments['xml'])['data'];

      $templateVariableContainer=$renderingContext->getVariableProvider();
      $templateVariableContainer->add($arguments['as'], $flexformArray);
      $output = $renderChildrenClosure();
      $templateVariableContainer->remove($arguments['as']);
      return $output;
  }

}
