<?php
namespace Internetgalerie\IgRender\ViewHelpers\Format;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

class CurrencyViewHelper extends AbstractViewHelper
{
    use CompileWithRenderStatic;

    /**
     * Output is escaped already. We must not escape children, to avoid double encoding.
     *
     * @var bool
     */
    protected $escapeChildren = false;

    /**
     * Initialize arguments.
     *
     * @throws \TYPO3Fluid\Fluid\Core\ViewHelper\Exception
     */
    public function initializeArguments()
    {
        $this->registerArgument('currency', 'string', 'The currency ISO Code e.g. USD or EUR', false, null);
        $this->registerArgument('locale', 'string', 'The locale to use e.g. de_CH', false, null);
        $this->registerArgument('amount', 'mixed', 'string or double or int');
    }

    
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $currentLocale = $arguments['locale'] ?? setlocale(LC_MONETARY, 0);
        $currency = $arguments['currency'];
        //dangers? maybe currency should be mandatory
        if ($currency === null) {
            $localeInfo = localeconv();
            $currency = $localeInfo['int_curr_symbol'];
        }

        // .utf8 + @currency not working
        $fmt = new \NumberFormatter(str_replace('.utf8', '', $currentLocale) . '@currency=' . $currency, \NumberFormatter::CURRENCY);
        if ($arguments['amount']) {
            $floatToFormat = $arguments['amount'];
        } else {
            $floatToFormat = floatval($renderChildrenClosure());
        }
        return $fmt->format($floatToFormat);
        //$symbol = $fmt->getSymbol(\NumberFormatter::CURRENCY_SYMBOL);
    }
}
