<?php
namespace Internetgalerie\IgRender\ViewHelpers\Map;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2014 Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
class DirectionsServiceViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    public static $instanceCount = 0;

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this -> registerArgument('destination', 'string', 'destination', false, '');
        $this -> registerArgument('origin', 'string', 'origin', false, '');
        $this -> registerArgument('travelMode', 'string', 'travelMode: DRIVING', false, 'DRIVING');
    }

    public function render()
    {
        $ds = [];
        $ds['destination']=$this->arguments['destination'];
        $ds['origin']=$this->arguments['origin'];
        $ds['travelMode']=$this->arguments['travelMode'];
        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $__googleMap=$templateVariableContainer->get('__googleMap');
        $__googleMap['directionsService'][]=$ds;
        $templateVariableContainer = $templateVariableContainer->add('__googleMap', $__googleMap);
        return '';
        return $content="var directionsService = new google.maps.DirectionsService();
	    directionsDisplay = new google.maps.DirectionsRenderer();
	    directionsDisplay.setMap(map);
	    directionsService.route({
	      origin: ".json_encode($ds['origin']).",
		  destination: ".json_encode($ds['destination']).",
		  travelMode: ".json_encode($ds['travelMode']).",
		  }, function(result, status) {
		console.log('result'+status);
		if (status == 'OK') {
		  directionsDisplay.setDirections(result);
		}
	      });";
    
      
        //	$ds['extraJs'] = trim($this->renderChildren());
      $this -> addMarker($ds);//
    }

    public function addMarker($marker)
    {
        $layers = $this -> templateVariableContainer -> get('layers');
        if (!count($layers)) {
            $layers[] = array('markers' => array());
        }

        end($layers);
        $last = key($layers);
        $layers[$last]['directionsService'][] = $marker;

        $this -> templateVariableContainer -> remove('layers');
        $this -> templateVariableContainer -> add('layers', $layers);
    }

    /**
     * get the position of the map
     * first, it checks latlng argument
     * then, lat and lng arguments
     *
     * @return array array('lat'=>latitude, 'lng'=>longitude)
     */
    protected function getLatLng()
    {
        $res = array();
        if ($this -> hasArgument('lat') && $this -> hasArgument('lng')) {
            // both argumets set
            $res = array('lat' => floatval($this -> arguments['lat']), 'lng' => floatval($this -> arguments['lng']));
        } elseif ($this -> hasArgument('latlng')) {
            $lat = $lng = null;
            //first priority: commaseparated string or array
            if (is_array($this -> arguments['latlng'])) {
                if (isset($this -> arguments['latlng']['lat'])) {
                    $lat = $this -> arguments['latlng']['lat'];
                    $lng = $this -> arguments['latlng']['lng'];
                } else {
                    $lat = $this -> arguments['latlng'][0];
                    $lng = $this -> arguments['latlng'][1];
                }
            } else {
                list($lat, $lng) = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(',', $this -> arguments['latlng'], true);
            }
            $res = array('lat' => floatval($lat), 'lng' => floatval($lng));
        }
        //validate
        /*
         * XXX: theoretically, this makes it impossible to set the center to (0,0)
         * but since there is only sea and we don't have customers from africa, we can simply ignore that.
         */
        if (!(count($res) == 2 && $res['lat'] && $res['lng'] && $res['lat'] >= -90.0 && $res['lat'] <= 90.0 && $res['lng'] >= -180.0 && $res['lng'] <= 180.0)) {
            return false;
        }
        return $res;
    }
}
