<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
/**
 * render the content element with uid
 */
class ContentViewHelper extends AbstractViewHelper
{

    /**
     * @var boolean
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        $this->registerArgument('uid', 'integer', 'Colnumber', false);
        $this->registerArgument('pageUid', 'integer', 'Page UID', false);
    }


    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        /*
               $conf = array( // RECORDS
              'tables' => 'tt_content',
              'source' => $uid,
                  'conf.' => array(

                   'tt_content.' => array ('select.'=> array( 'languageField' => 'sys_language_uid' ))
                   ),

          'languageField' => 'sys_language_uid',
              'dontCheckPid' => 1
          );*/
        // TODO: sehr doof

        $dbConnection  = GeneralUtility::makeInstance('TYPO3\CMS\Core\Database\ConnectionPool')->getConnectionForTable('tt_content');
        $queryBuilder= GeneralUtility::makeInstance('TYPO3\CMS\Core\Database\ConnectionPool')->getQueryBuilderForTable('tt_content');

        $contentObjectRenderer = static::getContentObjectRenderer();


        $expressionBuilder = $dbConnection->getExpressionBuilder();
        $frontendRestriction = GeneralUtility::makeInstance('TYPO3\CMS\Core\Database\Query\Restriction\FrontendRestrictionContainer');
        $queryBuilder->select('uid', 'pid')->from('tt_content');
        $queryBuilder->setRestrictions($frontendRestriction);
        $uid = 0;
        if ($arguments['uid']) {
            $uid=$arguments['uid'];
            $queryBuilder->where($expressionBuilder->eq('uid', $uid));
            $statement = $queryBuilder->executeQuery();
            if ($row = $statement->fetchAssociative()) {
                $conf = array( // CONTENT
              'table' => 'tt_content',
              'select.' => array(
                      'pidInList' => $row['pid'],
                      'where' => '(uid='.intval($uid).' OR l18n_parent='.intval($uid) .')',
                      'languageField' => 'sys_language_uid'
                      ),
             );
                //return $GLOBALS['TSFE']->cObj->cObjGetSingle('CONTENT', $conf);
                return $contentObjectRenderer->cObjGetSingle('CONTENT', $conf);
            }
        }

        $pageUid = 0;
        if ($arguments['pageUid']) {
            $pageUid=$arguments['pageUid'];
            $queryBuilder->where($expressionBuilder->eq('pid', $pageUid))->orderBy('sorting', 'ASC');
        }


        $statement = $queryBuilder->executeQuery();
        $uidList=[];
        while ($row = $statement->fetchAssociative()) {
            $uidList[]=$row['uid'];
        }
        $sqlWhere = '(uid='.intval($uid).' OR l18n_parent='.intval($uid) .')';
        if (ExtensionManagementUtility::isLoaded('gridelements')) {
            $sqlWhere .= '  AND tx_gridelements_columns=0';
        }
        if (ExtensionManagementUtility::isLoaded('container')) {
            $sqlWhere .= '  AND tx_container_parent=0';
        }
        $conf = [ // CONTENT
            'table' => 'tt_content',
            'select.' => [
                'pidInList' => $pageUid,
                'where' => $sqlWhere,
                'languageField' => 'sys_language_uid'
            ],
        ];
        // 		    'htmlSpecialChars' => 0

        /*   $conf = array( // RECORDS
              'tables' => 'tt_content',
              'source' => $uid,
          'source.' => array (
                  'cObject' => 'CONTENT',
                  'cObject.' => array (
                               'table' => 'tt_content',
                               'select.' => array (
                                       'pidInList' => 24,
                                       'languageField' => 'sys_language_uid'
                                       )
                               )
                   ),
              'dontCheckPid' => 1
          );
*/
        return $contentObjectRenderer->cObjGetSingle('CONTENT', $conf);

        //return 'MENU';
      //return $this->cObj->CONTENT($conf);
    //return $this->cObj->RECORDS($conf);
    }

    /**
     * @return ContentObjectRenderer
     */
    protected static function getContentObjectRenderer()
    {
        return GeneralUtility::makeInstance(
            ContentObjectRenderer::class,
            $GLOBALS['TSFE']
        );
    }
}
