<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class AspectPropertyViewHelper extends AbstractViewHelper
{
    public function initializeArguments()
    {
        $this->registerArgument('name', 'string', '', true);
        $this->registerArgument('property', 'string', 'Name for the frontendUser object', false, null);
        $this->registerArgument('default', 'string', 'Name for the frontendUser object', false, '');
    }

    /**
     * Returns a property from the aspect or default if not found
     *
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
    {
        return GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect($arguments['name'], $arguments['property'], $arguments['default']);
    }
}
