<?php
namespace Internetgalerie\IgRender\TypoUserFunction;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2011 Jo Hasenau <info@cybercraft.de>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;

/**
 * Initialize Flexform values
 *
 * @author        Jo Hasenau <info@cybercraft.de>
 * @package       TYPO3
 * @subpackage    tx_gridelements
 */
class FlexformInit extends ContentObjectRenderer
{

    /**
     * The main method of the PlugIn
     *
     * @param    string $content The PlugIn content
     * @param    array  $conf    The PlugIn configuration
     *
     * @return   string 		 The content that is displayed on the website
     */
    public function main($content = '', $conf = array())
    {

        // first we have to take care of possible flexform values containing additional information
        // that is not available via DB relations. It will be added as "virtual" key to the existing data Array
        // so that you can easily get the values with TypoScript
        $this->initPiFlexForm();
        $this->getPiFlexFormData();
    }
    
    /**
     * Converts $this->cObj->data['pi_flexform'] from XML string to flexForm array.
     *
     * @param    string $field Field name to convert
     *
     * @return   void
     */
    public function initPIflexForm($field = 'pi_flexform')
    {
        // Converting flexform data into array:
        if (!is_array($this->cObj->data[$field]) && $this->cObj->data[$field]) {
            $this->cObj->data[$field] = GeneralUtility::xml2array($this->cObj->data[$field]);
            if (!is_array($this->cObj->data[$field])) {
                $this->cObj->data[$field] = array();
            }
        }
    }
    
    /**
     * fetches values from the grid flexform and assigns them to virtual fields in the data array
     *
     * @return void
     */
    public function getPiFlexFormData()
    {
        $piFlexForm = $this->cObj->data['pi_flexform'];

        if (is_array($piFlexForm) && is_array($piFlexForm['data'])) {
            foreach ($piFlexForm['data'] as $sheet => $data) {
                foreach ($data as $lang => $value) {
                    foreach ($value as $key => $val) {
                        $this->cObj->data['flexform_' . $key] = $this->getFFvalue($piFlexForm, $key, $sheet);
                    }
                }
            }
        }

        unset($piFlexForm);
    }
    
    /**
     * Return value from somewhere inside a FlexForm structure
     *
     * @param    array  $T3FlexForm_array FlexForm data
     * @param    string $fieldName        Field name to extract. Can be given like "test/el/2/test/el/field_templateObject" where each part will dig a level deeper in the FlexForm data.
     * @param    string $sheet            Sheet pointer, eg. "sDEF"
     * @param    string $lang             Language pointer, eg. "lDEF"
     * @param    string $value            Value pointer, eg. "vDEF"
     *
     * @return   string        			  The content.
     */
    public function getFFvalue($T3FlexForm_array, $fieldName, $sheet = 'sDEF', $lang = 'lDEF', $value = 'vDEF')
    {
        $sheetArray = is_array($T3FlexForm_array) ? $T3FlexForm_array['data'][$sheet][$lang] : '';
        if (is_array($sheetArray)) {
            return $this->getFFvalueFromSheetArray($sheetArray, explode('/', $fieldName), $value);
        }
    }
    
    /**
     * Returns part of $sheetArray pointed to by the keys in $fieldNameArray
     *
     * @param   array  $sheetArray   Multidimensional array, typically FlexForm contents
     * @param   array  $fieldNameArr Array where each value points to a key in the FlexForms content - the input array will have the value returned pointed to by these keys. All integer keys will not take their integer counterparts, but rather traverse the current position in the array an return element number X (whether this is right behavior is not settled yet...)
     * @param   string $value        Value for outermost key, typ. "vDEF" depending on language.
     *
     * @return  mixed         		 The value, typ. string.
     * @access 	private
     * @see    	pi_getFFvalue()
     */
    public function getFFvalueFromSheetArray($sheetArray, $fieldNameArr, $value)
    {
        $tempArr = $sheetArray;
        foreach ($fieldNameArr as $k => $v) {
            $checkedValue = MathUtility::canBeInterpretedAsInteger($v);
            if ($checkedValue) {
                if (is_array($tempArr)) {
                    $c = 0;
                    foreach ($tempArr as $values) {
                        if ($c == $v) {
                            $tempArr = $values;
                            break;
                        }
                        $c++;
                    }
                }
            } else {
                $tempArr = $tempArr[$v];
            }
        }
        if (is_array($tempArr['el'])) {
            $out = $this->getFlexformSectionsRecursively($tempArr['el'], $value);
        } else {
            $out = $tempArr[$value];
        }
        return $out;
    }
    
    /**
     * @param array  $dataArr
     * @param string $valueKey
     *
     * @return array
     */
    protected function getFlexformSectionsRecursively($dataArr, $valueKey = 'vDEF')
    {
        $out = array();
        foreach ($dataArr as $k => $el) {
            if (is_array($el) && is_array($el['el'])) {
                $out[$k] = $this->getFlexformSectionsRecursively($el['el']);
            } elseif (is_array($el) && is_array($el['data']['el'])) {
                $out[] = $this->getFlexformSectionsRecursively($el['data']['el']);
            } else {
                if (isset($el['vDEF'])) {
                    $out[$k] = $el['vDEF'];
                }
            }
        }
        return $out;
    }
}
