<?php
namespace Internetgalerie\IgRender\ViewHelpers;


use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithContentArgumentAndRenderStatic;

//    use CompileWithContentArgumentAndRenderStatic;
class LocaleViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('category', 'string', 'category of the functions affected by the locale setting ', false, ' LC_ALL');        
        $this->registerArgument('locale', 'string', 'Locale to use');        
    }


    /**
     * Output is escaped already. We must not escape children, to avoid double encoding.
     *
     * @var bool
     */
    protected $escapeChildren = false;

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     *
     * @return string
     * @throws Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $categoriesAllowed = [
            'LC_ALL' => LC_ALL,
            'LC_COLLATE' => LC_COLLATE,
            'LC_CTYPE' => LC_CTYPE,
            'LC_MONETARY' => LC_MONETARY,
            'LC_NUMERIC' => LC_NUMERIC,
            'LC_TIME' => LC_TIME,
            'LC_MESSAGES' => LC_MESSAGES
        ];
        
        
        $category = $categoriesAllowed[$arguments['category']] ?? LC_ALL;

        // LC_ALL -> backup all values for all categories ?
        $currentLocale = setlocale($category, 0);
        if (isset($arguments['locale'])) {
            setlocale($category, $arguments['locale']);
        }
        $ret = $renderChildrenClosure();
        setlocale($category, $currentLocale);
        return $ret;
    }
}
