<?php

namespace Internetgalerie\IgRender\Utility;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class SliderConfigUtility
{
    protected const DEFAUL_CONFIG_NAME = 'slick';
    public static function checkInitialSlide(string $initialSlide)
    {
        if (!in_array($initialSlide, ['random', 'last'])) {
            return (int) $initialSlide;
        }
        return $initialSlide;
    }


    public static function get($arguments)
    {
        $configurationManager = GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\Configuration\ConfigurationManager::class);
        $typoscript = $configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT
        );
        $sliderType = $typoscript['plugin.']['tx_igrender.']['settings.']['slider.']['type'] ?? self::DEFAUL_CONFIG_NAME;

        // aria labels for slider
        $ariaLabelPrev = LocalizationUtility::translate('LLL:EXT:core/Resources/Private/Language/locallang_common.xlf:previous');
        $ariaLabelNext = LocalizationUtility::translate('LLL:EXT:core/Resources/Private/Language/locallang_common.xlf:next');

        /**
         * The configuration for the slider.
         *
         * @var array
         */
        $SLIDER_CONFIGURATION = [
            'splide' => [
                'js' => [],
                'css' => [],
                'settings' => [
                    'slide' => ".ig-slider-slide",
                    'adaptiveHeight' => false,
                    'dots' => true,
                    'arrowPath' => 'm 12.5 3 l 15 17 l -15 17'
                ],
                'settingsJs' => [
                    'initialSlide' => 0, // muss int sein in JS
                    'draggable' => false, // war mal string.... warum?
                    'useHash' => false,
                ],
                'initClass' => 'splide',
                'sliderTag' => 'div',
                'slideContainerStart' => '<div class="splide__track"><ul class="splide__list">',
                'slideContainerStop' => '</ul></div>',
                'sliderArrowsHtml' => '<div class="splide__arrows"><button class="splide__arrow splide__arrow--prev" aria-label="' . $ariaLabelPrev. '"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40" width="40" height="40" focusable="false"><path class="st0" d="M0,0v40h40V0H0z M16.9,30.6l-1.8-1.8L24,20l-8.8-8.8l1.8-1.8L27.5,20L16.9,30.6z" /></svg><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40" width="40" height="40" focusable="false"><polygon points="15.1,11.2 24,20 15.1,28.8 16.9,30.6 27.5,20 16.9,9.4" /></svg></button><button class="splide__arrow splide__arrow--next" aria-label="' . $ariaLabelNext. '"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40" width="40" height="40" focusable="false"><path class="st0" d="M0,0v40h40V0H0z M16.9,30.6l-1.8-1.8L24,20l-8.8-8.8l1.8-1.8L27.5,20L16.9,30.6z" /></svg><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 40" width="40" height="40" focusable="false"><polygon points="15.1,11.2 24,20 15.1,28.8 16.9,30.6 27.5,20 16.9,9.4" /></svg></button></div>',
                'slideTag' => 'li',
                'initJsCode' => 'slick',
                'arguments' => [
                    'fade' => 'fade',
                    'swipe' => 'swipe',
                    'useAutoplayToggleButton' => 'useAutoplayToggleButton',
                    'useArrows' => 'useArrows',
                    'useDots' => 'useDots',
                    'slidesToShow' => 'slidesToShow',
                    'initialSlide' => 'initialSlide',
                    'useHash' => 'useHash',
                    'autoplay' => 'autoplay',
                    'autoplaySpeed' => 'autoplaySpeed',
                    'autoplaySpeedSec' => [
                        'settingName' => 'autoplaySpeed',
                        'function' => function ($val) {
                            return $val * 1000;
                        },
                    ],
                    'speed' => 'speed',
                    'speedSec' => [
                        'settingName' => 'speed',
                        'function' => function ($val) {
                            return $val * 1000;
                        },
                    ],
                ],
            ],
            /**
             * slick:
             * http://kenwheeler.github.io/slick/
             */
            'slick' => [
                'js' => [
                    'EXT:ig_render/Resources/Public/slick/slick.min.js',
                    'EXT:ig_render/Resources/Public/slick/centerMode.js',
                    'EXT:ig_render/Resources/Public/JavaScript/ig-slick.js',
                ],
                'css' => [
                    'EXT:ig_render/Resources/Public/slick/slick.scss',
                    'EXT:ig_render/Resources/Public/slick/slick-theme.css',
                ],
                'settings' => [
                    'slide' => ".ig-slider-slide",
                    'adaptiveHeight' => false,
                    'dots' => true,
                ],
                'settingsJs' => [
                    //'prevArrow' => '$(".previous")',
                    //'nextArrow' => '$(".next")',
                    //'appendDots' => '$(".dots")',
                    //'draggable' => 'false',
                    'draggable' => false, // war mal string.... warum?
                    //'init' => '',
                    'initialSlide' => 0, // muss int sein in JS
                    'useHash' => false,
                ],
                'initClass' => 'ig-slider',
                'sliderTag' => 'div',
                'slideTag' => 'div',
                'slideContainerStart' => '',
                'slideContainerStop' => '',
                'sliderArrowsHtml' => '',
                'initJsCode' => 'slick',
                'arguments' => [
                    'fade' => 'fade',
                    'swipe' => 'swipe',
                    'useAutoplayToggleButton' => 'useAutoplayToggleButton',
                    'useArrows' => 'useArrows',
                    'useDots' => 'useDots',
                    'slidesToShow' => 'slidesToShow',
                    'initialSlide' => 'initialSlide',
                    'useHash' => 'useHash',
                    'autoplay' => 'autoplay',
                    'autoplaySpeed' => 'autoplaySpeed',
                    'autoplaySpeedSec' => [
                        'settingName' => 'autoplaySpeed',
                        'function' => function ($val) {
                            return $val * 1000;
                        },
                    ],
                    'speed' => 'speed',
                    'speedSec' => [
                        'settingName' => 'speed',
                        'function' => function ($val) {
                            return $val * 1000;
                        },
                    ],
                ],
                //'beforeInitJsCode' => '$(\'.{CLASSNAME}\').on(\'init\',function(event, slick){$(\'.{CLASSNAME}\').removeClass(\'ig-slider-onload\');$(\'.{CLASSNAME} .ig-slider-slide\').show();});',
            ],
        ];

        $configName = trim($arguments['config'] ?? self::DEFAUL_CONFIG_NAME);
        $className = trim($arguments['classname'] ?? '');
        if (!str_contains($sliderType, 'slick') && $configName != $sliderType) {
            $configName = trim($sliderType);
        }
        if(!$configName){
            $configName = self::DEFAUL_CONFIG_NAME;
        }

        // slick-slider is not unique - it is the defaut class for slick sliders
        if (empty($className) || $className == 'slick-slider') {
            // @todo ugly destories scriptmerger cache
            $className = 'ig-slider-default'; // . uniqid();
        }

        if (!isset($SLIDER_CONFIGURATION[$configName])) {
            throw new \Exception('Given slider configuration doesn\'t exist: "' . $configName . '"');
        }

        // TypoScript Settings holen

        $configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);

        // @todo change in 12.0
        //$configurationManager = GeneralUtility::makeInstance(ConfigurationManagerInterface::class);
        $extbaseFrameworkConfiguration = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $settingsTS = $extbaseFrameworkConfiguration['plugin.']['tx_igrender.']['settings.']['slider.'] ?? [];
        $settingsNameTS = isset($settingsTS[($arguments['settingsName'] ?? '') . '.']) ? $settingsTS[($arguments['settingsName'] ?? '') . '.'] : [];
        
        if (isset($settingsTS['type']) && $settingsTS['type'] == 'slick-accessible') {
            $SLIDER_CONFIGURATION['slick']['settings']['slide'] = '';
        }
        $selectedConfig = $SLIDER_CONFIGURATION[$configName];
        /*
        if(!$extbaseFrameworkConfiguration['plugin.']['tx_igrender.']['settings.']['slick.']['enable']) {
        // JS + CSS laden mit assets (cache)
            $pageRenderer = GeneralUtility::makeInstance(\Internetgalerie\IgRender\Utility\PageRendererUtility::class);
            foreach ($selectedConfig['js'] as $nr => $file) {
                $pageRenderer->addJsFooterFile($file);
            }
            foreach ($selectedConfig['css'] as $nr => $file) {
                $pageRenderer->addCssFile($file);
            }
        }
        */
        $settingsCustomer = $arguments['settings'] ?? [];
        if (!empty($settingsCustomer) && is_array($settingsCustomer)) {
            foreach ($settingsCustomer as $name => $value) {
                if (isset($selectedConfig['settingsJs'][$name])) {
                    unset($selectedConfig['settingsJs'][$name]);
                }
            }
        }
        if (isset($settingsNameTS['settings.'])) {
            foreach ($settingsNameTS['settings.'] as $name => $value) {
                // TypoScript Setting nur falls nichts definiert
                if (!isset($settingsCustomer[$name])) {
                    $settingsCustomer[$name] = $value;
                }
            }
        }
        foreach ($selectedConfig['arguments'] as $argName => $c) {
            if (isset($arguments[$argName])) {
                if (is_array($c)) {
                    if (isset($c['function'])) {
                        $settingsCustomer[$c['settingName']] = call_user_func($c['function'], $arguments[$argName]);
                    } else {
                        $settingsCustomer[$c['settingName']] = $arguments[$argName];
                    }
                } else {
                    $settingsCustomer[$c] = $arguments[$argName];
                }
            }
        }
        // Get the default settings and merge them with the custom settings
        $settingsArray = $selectedConfig['settings'] ?? [];

        if (isset($settingsCustomer) && count($settingsCustomer) > 0) {
            foreach ($settingsCustomer as $key => &$val) {
                if ($val === 'true') {
                    $settingsArray[$key] = true; //ugly lightSlider needs boolean as true or false (0/1 not working)
                } elseif ($val === 'false') {
                    $settingsArray[$key] = false;
                } else {
                    $settingsArray[$key] = $val;
                }
            }
        }
        // Replace all Tags in the settings - compatibility
        foreach ($settingsArray as $key => $val) {
            if (is_string($val)) {
                $settingsArray[$key] = str_replace('.{CLASSNAME}', '', $val);
                //$settingsArray[$key] = str_replace('{CLASSNAME}', str_replace(' ', '.', $className), $val);
                //echo($key .'='. gettype($val) ."=".str_replace('{CLASSNAME}', $className,$val)."<br />\n");
            }
        }
        $selectedConfig['classname'] = $className;


        if (isset($arguments['slidesToShow']) && $arguments['slidesToShow'] > 1) {
            // Responsive Verhalten bei mehreren Slides pro Seite
            if (isset($settingsNameTS['responsive.'][$arguments['slidesToShow'] . '.'])) {
                $settingsArray['responsive'] = [];
                foreach ($settingsNameTS['responsive.'][$arguments['slidesToShow'] . '.'] as $entry) {
                    $entry['settings'] = $entry['settings.'];
                    unset($entry['settings.']);
                    if (trim($settingsTS['type']) == 'splide') {
                        $settingsArray['breakpoints'][$entry['breakpoint']] = self::getValue($entry['settings']);
                    } else {
                        $settingsArray['responsive'][] = self::getValue($entry);
                    }
                }
            }
        }

        $selectedConfig['settingsArray'] = $settingsArray;

        /*
        if ($selectedConfig['afterInitJsCode']) {
            $selectedConfig['afterInitJsCode'] = str_replace('{CLASSNAME}', str_replace(' ', '.', $className), $selectedConfig['afterInitJsCode']);
        }
        if ($selectedConfig['beforeInitJsCode']) {
            $selectedConfig['beforeInitJsCode'] = str_replace('{CLASSNAME}', str_replace(' ', '.', $className), $selectedConfig['beforeInitJsCode']);
        }
        */
        // Get the default settingsJs and merge them with the custom settingsJs


        $settingsJsArray = $selectedConfig['settingsJs'] ?? [];


        // Merge needed arguments with settingsJs        
        if ($settingsCustomer['initialSlide'] ?? false) {
            $settingsJsArray['initialSlide'] = $settingsCustomer['initialSlide'];
        }
        if ($settingsCustomer['useHash'] ?? false) {
            $settingsJsArray['useHash'] = self::getValue($settingsCustomer['useHash']);
        }
        $settingsCustomer = $arguments['settingsJs'] ?? [];

        if ($arguments['randomFirst'] ?? false) {
            $settingsJsArray['initialSlide'] = 'random';
            //'Math.floor(Math.random() * jQuery(\'.' . $selectedConfig['classname'] . ' ' . $settingsArray['slide'] . '\').length)';
        }


        if (isset($settingsCustomer) && count($settingsCustomer) > 0) {
            foreach ($settingsCustomer as $key => &$val) {
                $settingsJsArray[$key] = $val; // str_replace('.{CLASSNAME}', '', $val);
            }
        }
        /*
        foreach ($settingsJsArray as $key => $val) {
            //$val = str_replace('{CLASSNAME}', str_replace(' ', '.', $className), $val);
            $val = str_replace('.{CLASSNAME}', '', $val);
            if (!isset($settingsArray[$key])) {
                $settingsJs .= ', ' . $key . ':' . $val;
            }
        }
        */
        $selectedConfig['dataSettings'] = array_merge($settingsArray, $settingsJsArray);

        /*
        $selectedConfig['settingsJs']['slide'] = '.ig-slider-slide';
        $selectedConfig['settingsJs']['prevArrow'] = '$(".previous", this)';
        $selectedConfig['settingsJs']['nextArrow'] = '$(".next", this)';
        $selectedConfig['settingsJs']['appendDots'] = '$(".dots", this)';
        */
        //$selectedConfig['settings'] = substr($settings, 0, -1) . $settingsJs . '}';

        return $selectedConfig;
    }

    public static function getValue($val)
    {
        if ($val === 'true') {
            return true;
        } elseif ($val === 'false') {
            return false;
        } elseif (strval(intval($val)) == $val) {
            return intval($val);
        } elseif (is_array($val)) {
            $newval = [];
            foreach ($val as $name => $value) {
                $newval[$name] = self::getValue($value);
            }
            return $newval;
        } else {
            return $val;
        }
    }
}
