<?php
namespace Internetgalerie\IgRender\Utility;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class PageRendererUtility implements \TYPO3\CMS\Core\SingletonInterface
{
    protected $assets=[];
  
    public function reset()
    {
        $this->assets=[
           'jsFooterFile' => [],
           'jsFooterInlineCode' => [],
           'cssFile' => [],
           ];
    }
    public function getAssets()
    {
        return $this->assets;
    }
    public function addAssets($assets)
    {
        foreach ($assets['jsFooterFile'] as $file) {
            $this->addJsFooterFile($file);
        }
        foreach ($assets['jsFooterInlineCode'] as $name=>$block) {
            $this->addJsFooterInlineCode($name, $block);
        }
        foreach ($assets['cssFile'] as $file) {
            $this->addCssFile($file);
        }
    }

    public function addJsFooterFile($file)
    {
        $this->assets['jsFooterFile'][]=$file;
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $pageRenderer->addJsFooterFile($file);
    }

    public function addCssFile($file)
    {
        $this->assets['cssFile'][]=$file;
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $pageRenderer->addCssFile($file);
    }
    public function addJsFooterInlineCode($name, $block)
    {
        $this->assets['jsFooterInlineCode'][$name]=$block;
        $pageRenderer=GeneralUtility::makeInstance(\TYPO3\CMS\Core\Page\PageRenderer::class);
        $pageRenderer->addJsFooterInlineCode($name, $block);
    }
}
