<?php
namespace Internetgalerie\IgRender\ViewHelpers\Css;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class StyleViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    protected $escapeOutput = false;
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this -> registerArgument('file', 'string', '', false);
    }

    public function render()
    {
        if ($this -> arguments['file']) {
            $file = GeneralUtility::getFileAbsFileName($this -> arguments['file']);
            if (file_exists($file)) {
                return '<style>' . file_get_contents($file) . '</style>';
            }
        }
        return '';
    }
}
