<?php

namespace Internetgalerie\IgRender\ViewHelpers\Condition\String;


use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * ### Condition: String starts with a given substring
 *
 * Condition ViewHelper which renders the `then` child if provided
 * Performs a case-sensitive check indicating if $haystack begins with $needle. 
 */
class StartsWithViewHelper extends AbstractConditionViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('haystack', 'string', 'haystack', true);
        $this->registerArgument('needle', 'string', 'need', true);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext): bool
    {
        return substr($arguments['haystack'], 0, strlen($arguments['needle'])) == $arguments['needle'];
    }
}
