<?php
namespace Internetgalerie\IgRender\ViewHelpers\File;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use TYPO3\CMS\Core\Imaging\Icon;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Documentation\Domain\Model\DocumentTranslation;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

/**
 * ViewHelper to display the icon for a given file extension
 *
 * Example: <ig:file.icon extension="pdf" />
 *
 * @internal
 */
class IconViewHelper extends AbstractViewHelper
{
    use CompileWithRenderStatic;

    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initializes the arguments
     *
     * @throws \TYPO3Fluid\Fluid\Core\ViewHelper\Exception
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('extension', 'string', 'Extension', false);
        $this->registerArgument('uri', 'string', 'File URI', false);
        $this->registerArgument('size', 'string', 'Grösse des Files (small: 16px, large: 48px, default: 32px)', false, 'small');
    }

    /**
     * Statically renders all format download links.
     *
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     *
     * @return string
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        /** @var IconFactory $iconFactory */
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        if ($arguments['size']=='small') {
            $iconSize=Icon::SIZE_SMALL;
        } elseif ($arguments['size']=='large') {
            $iconSize=Icon::SIZE_LARGE;
        } else {
            $iconSize=Icon::SIZE_DEFAULT;
        }
        $extension='';
        if ($arguments['uri']) {
            $uri=$arguments['uri'];
            $extension = substr($uri, strrpos($uri, '.') + 1);
        }
        if ($arguments['extension']) {
            $extension=$arguments['extension'];
        }
        return $iconFactory->getIconForFileExtension($extension, $iconSize)->render();
    }
}
