<?php

namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class FrontendUserViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('as', 'string', 'Name for the frontendUser object', false, 'frontendUser');
        $this->registerArgument('property', 'string', 'Property of user object', false);
    }
    public function render(): mixed
    {
        $context = GeneralUtility::makeInstance(Context::class);
        if ($this->arguments['property'] ?? false) {
            $frontendUserProperty = $context->getPropertyFromAspect('frontend.user', $this->arguments['property']) ?? '';
            return $frontendUserProperty;
        }
        $frontendUser = $context->getAspect('frontend.user');

        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $frontendUser);
        $output = trim($this->renderChildren());
        $templateVariableContainer->remove($arguments['as']);

        return $output;
    }
}
