<?php
namespace Internetgalerie\IgRender\ViewHelpers\Tabs;

use Internetgalerie\IgRender\Utility\TabsUtility;
use Internetgalerie\IgRender\ViewHelpers\TabsViewHelper;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TabViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;
    
    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('title', 'string', 'The title of the tab.', true, '');
        $this->registerArgument('class', 'string', 'CSS class', false);
        $this->registerArgument('name', 'string', 'Tab Name/ID', false, null);
        $this->registerArgument('headerClass', 'string', 'Extra Classes for header', false);
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
    {
        $viewHelperVariableContainer = $renderingContext->getViewHelperVariableContainer( );
        if ($viewHelperVariableContainer->exists(TabsViewHelper::class, 'tabsUtility')) {
            $tabsUtility = $viewHelperVariableContainer->get(TabsViewHelper::class, 'tabsUtility');
        } else {
            // we should never get here
            $tabsUtility = GeneralUtility::makeInstance(TabsUtility::class);
        }

            
        $tab = $tabsUtility->addTitle($arguments['title'], $arguments['headerClass'], $arguments['name']);
        $activeTabName = $tabsUtility->getActiveTabName();
    
        $additionalClass = 'ig-tabs-tab ig-tabs-tab-' . $tab['name'];
        if ($arguments['class']) {
            $additionalClass .= ' ' . $arguments['class'];
        }

        return '<div class="' . $additionalClass . '" data-tab-name="'.$tab['name'].'"' . ($tabsUtility->isActive($tab) ? '' : ' style="display: none;"') . '>'.  $renderChildrenClosure() .'</div>';
    }
}
