<?php
namespace Internetgalerie\IgRender\Utility;

/*
Autor: Daniel Abplanalp
Integration Controller:
          $igFlow = GeneralUtility::makeInstance(IgFlow::class);
          $igFlow->setLineWidth(4);
      //$igFlow->setLineHeightMode($igFlow::$LineHeightMode_FIX);
      //$igFlow->setLineHeight(2);
      foreach ($entries as $key => $entry) {
        $igFlow->add($entry, $entry->getWidth(), $entry->getHeight());
      }
        $this->view->assign('lines', $igFlow->getLines());

In Tempalte:
 <f:for each="{lines}" as="line">
     <div class="ig-flow-line ig-flow-line-{line.height}">
           <f:for each="{line.rows}" as="row">
                <div class="ig-flow-row ig-flow-row-{row.width}">
                    <f:for each="{row.entries}" as="entry">
              <div class="{entry.css}">
                <div>
                          <f:render partial="Category/ShowEntry" arguments="{category: entry.object, settings: settings}" />
            </div>
              </div>
                    </f:for>
                    </div>
           </f:for>
     </div>
 </f:for>
*/



class IgFlow
{
    public static $LineHeightMode_AUTO = 0;
    public static $LineHeightMode_FIRST_ELEMENT = 1;
    public static $LineHeightMode_FIX = 2;

    // Wie soll die Zeielen Höhe bestimmt werden
    private $lineHeightMode= 0;

    // Aktuelle Zeilenhoehe
    private $lineHeight=0;
    // Zeilenbreite
    private $lineWidth=4;
    // Zeilennummer
    private $lineNumber=0;
  
    // Freie Plätze der aktuellen Zeile (Array (x,y) boolean Werte)
    private $currentLineFreeCells=[];
    // Zeilen mit Einträgen (Array von line)
    private $lines=[];
    /*
      line:
      array: [ 'height' => $this->lineHeight, 'rows' => [] ];

      rows:
      array:  [ 'entries'=> [], 'pos' => $pos, 'width'=>$width]

      entries:
      [$y . $x]= [ 'object' => $entry, 'css' => implode(' ', $css), 'width' => $width, 'height' => $height];

      pos:
      array: x positionen
    */
  
    public function __construct()
    {
    }

    // In Matrix nach passender Stelle suchen
    private function getFreeCell($width, $height)
    {
        // Freier Platz suchen
        $maxWidth=count($this->currentLineFreeCells);
        $maxHeight=isset($this->currentLineFreeCells[0]) ? count($this->currentLineFreeCells[0]) : 0;

        // Höhe der Matrix an Element anpassen
        if ($height>$maxHeight) {
            if ($this->lineHeightMode==self::$LineHeightMode_AUTO) {
                for ($x=0;$x<$this->lineWidth;$x++) {
                    for ($y=$this->lineHeight;$y<$height;$y++) {
                        $this->currentLineFreeCells[$x][$y]=true;
                    }
                }
                $maxHeight=isset($this->currentLineFreeCells[0]) ? count($this->currentLineFreeCells[0]) :0;
                $this->lineHeight=$maxHeight;
            }
        }

        for ($x=0; $x<=$maxWidth-$width;$x++) {
            for ($y=0; $y<=$maxHeight-$height;$y++) {
                $isFree=true;
                for ($entryX=$x;$entryX<$x+$width;$entryX++) {
                    for ($entryY=$y;$entryY<$y+$height;$entryY++) {
                        if ($this->currentLineFreeCells[$entryX][$entryY]==false) {
                            $isFree=false;
                            break 2;
                        }
                    }
                }
                if ($isFree) {
                    for ($entryX=$x;$entryX<$x+$width;$entryX++) {
                        for ($entryY=$y;$entryY<$y+$height;$entryY++) {
                            $this->currentLineFreeCells[$entryX][$entryY]=false;
                        }
                    }
                    return [$x,$y];
                }
            }
        }
        return false;
    }
  
    // Neue leere Zeile hinzufuegen
    private function addNewLine($height)
    {
        if ($this->lineHeightMode==self::$LineHeightMode_FIRST_ELEMENT || $this->lineHeightMode==self::$LineHeightMode_AUTO) {
            $this->lineHeight=$height;
        }

        $this->lines[]=[ 'height' => $this->lineHeight, 'rows' => [] ];

        $this->lineNumber++;

        // Matrix leeren/genereieren mit moeglichen Plaetzen/Zellen fuer einen Eintrag
        $this->currentLineFreeCells=[];
        for ($x=0;$x<$this->lineWidth;$x++) {
            $this->currentLineFreeCells[$x]=[];
            for ($y=0;$y<$this->lineHeight;$y++) {
                $this->currentLineFreeCells[$x][$y]=true;
            }
        }
    }
    // Element mit gegebender Grosse in vorhandenen freien Zellen platziern
    public function add($entry, $width, $height)
    {
        $this->width=$width;
        $this->height=$height;
        $css=[];
    

        $xy = $this->getFreeCell($width, $height);
        if ($xy===false) {
            $this->addNewLine($height);
            $xy = $this->getFreeCell($width, $height);
            if ($xy===false) {
                return false;
            }
        }
        $x=$xy[0];
        $y=$xy[1];
        //    echo( $x . ',' . $y .'<br />');
        if ($xy!==false) {
            $found=0;
            $this->lines[$this->lineNumber-1]['height']=$this->lineHeight;// Hoehe falls hoetig anpassen
            foreach ($this->lines[$this->lineNumber-1]['rows'] as $rowNr=> $row) {
                if (in_array($x, $row['pos'])) {
                    $rowAddNr=$rowNr;
                    $found=1;
                    // Ist Element grösser als Splate -> Spalte verbreitern
                    for ($i=$x;$i<$x+$width;$i++) {
                        if (!in_array($i, $row['pos'])) {
                            // Existiert Position  in anderen Spalten?
                            $rowCombined=false;
                            foreach ($this->lines[$this->lineNumber-1]['rows'] as $newRowNr=> $newRow) {
                                if ($newRowNr<=$rowNr) {
                                    continue;
                                }
                                if (in_array($i, $newRow['pos'])) {
                                    // Spalten zusammen führen
                                    $this->lines[$this->lineNumber-1]['rows'][$rowNr]['pos']=array_merge($this->lines[$this->lineNumber-1]['rows'][$rowNr]['pos'], $this->lines[$this->lineNumber-1]['rows'][$newRowNr]['pos']);
                                    $this->lines[$this->lineNumber-1]['rows'][$rowNr]['entries']=array_merge($this->lines[$this->lineNumber-1]['rows'][$rowNr]['entries'], $this->lines[$this->lineNumber-1]['rows'][$newRowNr]['entries']);
                                    $this->lines[$this->lineNumber-1]['rows'][$rowNr]['width']=$this->lines[$this->lineNumber-1]['rows'][$rowNr]['width']+ $this->lines[$this->lineNumber-1]['rows'][$newRowNr]['width'];
                                    unset($this->lines[$this->lineNumber-1]['rows'][$newRowNr]);
                                    $rowCombined=true;
                                }
                            }
                            if (!$rowCombined) {
                                $this->lines[$this->lineNumber-1]['rows'][$rowNr]['pos'][]=$i;
                                $this->lines[$this->lineNumber-1]['rows'][$rowNr]['width']=count($this->lines[$this->lineNumber-1]['rows'][$rowNr]['pos']);
                            }
                        }
                    }
                    break;
                }
            }
            if (!$found) {
                $pos=[];
                for ($i=$x;$i<$x+$width;$i++) {
                    $pos[]=$i;
                }
                $this->lines[$this->lineNumber-1]['rows'][]= [ 'entries'=> [], 'pos' => $pos, 'width'=>$width];
                $rowAddNr=count($this->lines[$this->lineNumber-1]['rows'])-1;
            }
            $css[]='ig-flow-box ig-flow-box-'.$width.'x'.$height;
            $css[]='ig-flow-pos-col-'.$x.' ig-flow-pos-row-'.$y;
      
            $this->lines[$this->lineNumber-1]['rows'][$rowAddNr]['entries'][$y . $x]= [ 'object' => $entry, 'css' => implode(' ', $css), 'width' => $width, 'height' => $height];
            // Hack um Eintraege neu zu sortieren fuer Ausgabe -> am schluss würde dies schneller gehen
            ksort($this->lines[$this->lineNumber-1]['rows'][$rowAddNr]['entries']);

            return true;
        }
        return false;
    }

    public function getLineNumber()
    {
        return $this->lineNumber;
    }
    public function getArea()
    {
        return $this->width*$this->height;
    }
    public function getWidth()
    {
        return $this->width;
    }
    public function getHeight()
    {
        return $this->height;
    }
    public function getLines()
    {
        return $this->lines;
    }
    public function getExtraCss()
    {
        $css=[];
        $css[]='ig-flow-lineNr-'.$this->lineNumber;
        $css[]='ig-flow-area-'.$this->getArea();
        $css[]='ig-flow-width-'.$this->width;
        $css[]='ig-flow-height-'.$this->height;
        $css[]='ig-flow-lineHeight-'.$this->lineHeight;
        if ($this->getHeight()>$this->getLineHeight()) {
            $css[]='ig-flow-height-error';
        }
        return implode(' ', $css);
    }

    public function getLineWidth()
    {
        return $this->lineWidth;
    }
    public function setLineWidth($lineWidth)
    {
        $this->lineWidth=$lineWidth;
    }
    public function getLineHeightMode()
    {
        return $this->lineHeightMode;
    }
    public function setLineHeightMode($lineHeightMode)
    {
        $this->lineHeightMode=$lineHeightMode;
    }
    public function getLineHeight()
    {
        return $this->lineHeight;
    }
    public function setLineHeight($lineHeight)
    {
        $this->lineHeight=$lineHeight;
    }
}
