<?php
namespace Internetgalerie\IgRender\ViewHelpers\Map;

/***************************************************************
 *  Copyright notice
 *
 *  (c) 2014 Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

class LayerViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper
{
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this -> registerArgument('icon', 'string', 'Icon filename', false);
        $this -> registerArgument('options', 'string', 'Options that will apply to ALL markers.');
    }

    /**
     * Add a layer of map markers
     *
     * @return string
     */
    public function render()
    {
        $layers = $this -> templateVariableContainer -> get('layers');

        $layer = array();
        $layer['markers'] = array();

        if ($this -> hasArgument('options') && is_array($this -> arguments['options']) || strpos($this -> arguments['options'], 'Array')) {
            throw new \Exception('Bitte Map Options ohne {...} rundum angeben und geschwungene Klammern mit \\ escapen ( ... \\{ style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR\\}, ... )!');
        }
        $layer['options'] = $this -> arguments['options'];
        $layer['icon'] = $this -> hasArgument('icon') ? $this -> arguments['icon'] : '';
        $layers[] = $layer;
        $layers[] = $layer;
        
        $this -> templateVariableContainer -> remove('layers');
        $this -> templateVariableContainer -> add('layers', $layers);
        $this -> renderChildren();
    }
}
