<?php
namespace Internetgalerie\IgRender\Utility;

class TabsUtility
{
    protected $index = 0;
    protected $tabs = [];
    protected $activeTabName = null;
    
    public function addTitle($title, $class, $name=null)
    {
        $index = $this->index;
        $currentName = $name ?? $index;
        $tab = [
            'name' => $currentName,
            'index' => $index,
            'title' => $title,
            'class' => $class,
        ];
        $this->tabs[] = $tab;
        $this->index++;
        return $tab;
    }
    public function new(array $conf=[])
    {
        $this->id = 0;
        $this->index = 0;
        $this->tabs = [];
        $this->activeTabName = $conf['activeTabName'] ?? null;
    }
    public function getMenu()
    {
        return $this->tabs;
    }
    public function getActiveTabName()
    {
        return $this->activeTabName;
    }
    public function isActive(array $tab)
    {
        if (isset($this->activeTabName)) {
            return $this->activeTabName === $tab['name'];
        } else {
            return $tab['index'] === 0;
        }
    }
}
