<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use Internetgalerie\IgRender\Utility\TabsUtility;

/**
 * Tabs Contioner
 * 
 * <ig:tabs activeTab="{activeTab}"><ig:tabs.tab title="title-register" name="tabname">Content</ig:tab></ig:tabs>
 */
class TabsViewHelper extends AbstractViewHelper
{
   protected $escapeOutput = false;

    /**
     * Initialize arguments
     *
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('activeTab', 'string', 'Name of the Active Tab', false, '');
        $this->registerArgument('class', 'string', 'CSS class', false);
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
    {
        $conf = [];
        if ($arguments['activeTab']) {
            $conf['activeTabName'] = $arguments['activeTab'];
        }
        $tabsUtility = GeneralUtility::makeInstance(TabsUtility::class);
        $tabsUtility->new($conf);
        // render container/tabs -> stored in tabUtility

        $viewHelperVariableContainer = $renderingContext->getViewHelperVariableContainer( );
        $backupTabsUtility = null;
        if ($viewHelperVariableContainer->exists(TabsViewHelper::class, 'tabsUtility')) {
            $backupTabsUtility = $viewHelperVariableContainer->get(TabsViewHelper::class, 'tabsUtility');
        }
        $viewHelperVariableContainer->addOrUpdate(TabsViewHelper::class, 'tabsUtility', $tabsUtility);

        $childOutput = $renderChildrenClosure();

        if( $backupTabsUtility !== null) {
            $viewHelperVariableContainer->addOrUpdate(TabsViewHelper::class, 'tabsUtility', $backupTabsUtility);
        } else {
            $viewHelperVariableContainer->remove(TabsViewHelper::class, 'tabsUtility');
        }
                
        $menuContent='';
        foreach ($tabsUtility->getMenu() as $menu) {
            $menuContent.='<li class="ig-tabs-menu-item'.($tabsUtility->isActive($menu) ? ' ig-tabs-menu-item-active' : '').' ig-tabs-menu-item-'.$menu['name'].' '.$menu['class'].'" data-tab-name="'.$menu['name'].'"><a href="#ig-tab-'.$menu['name'].'" class="ig-tabs-menu-item-link">'.htmlspecialchars($menu['title']).'</a></li>';
        }
        return '<div class="ig-tabs' . ($arguments['class'] ? ' '. $arguments['class'] : '') . '">
<ul class="ig-tabs-menu">
' . $menuContent . '
</ul>
<div class="ig-tabs-container">' . $childOutput .'
</div>
</div>';
    }
}
