<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\FrontendEditing\Service\ContentEditableWrapperService;
use TYPO3\CMS\FrontendEditing\Service\AccessService;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * show the content of the page col
 */

class ColViewHelper extends AbstractViewHelper
{
    /**
     * @var boolean
     */
    protected $escapeOutput = false;
    protected $escapeChildren = false;
    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        $this->registerArgument('colPos', 'integer', 'Colnumber', false, '0');
        $this->registerArgument('pageUid', 'integer', 'Page UID', false);
        $this->registerArgument('dropzone', 'boolean', 'Show Dropzone', false, '1');
        $this->registerArgument('gridColumn', 'integer', 'Gridelement Column', false);
        $this->registerArgument('gridContainer', 'integer', 'Gridelement Container UID', false);
    }

    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $content=$renderChildrenClosure();
        //$dropzoneContent = '';
        if (ExtensionManagementUtility::isLoaded('frontend_editing') && GeneralUtility::_GET('frontend_editing')) {
            if (strlen($content)<50 || 1) {
                $accessService = GeneralUtility::makeInstance(AccessService::class);
                if ($accessService->isEnabled()) {
                    $wrapperService = GeneralUtility::makeInstance(ContentEditableWrapperService::class);
                    $fields=[];
                    $pageUid=(int)$arguments['pageUid'] ? : $GLOBALS['TSFE']->id;
                    $fields['pid'] = (int) $pageUid;
                    if (isset($arguments['gridColumn'])) {
                        $fields['tx_gridelements_columns'] = (int) $arguments['gridColumn'];
                    }
                    if (isset($arguments['gridContainer'])) {
                        $fields['tx_gridelements_container'] = (int) $arguments['gridContainer'];
                    }
                    return $wrapperService->wrapContentWithDropzone(
                        'tt_content',
                        0, // element uid
                        $content, // Content
                        (int)$arguments['colPos'], // colPos
                        $fields,
                        false // prepend
                    );
                }
            }
        }
        
        return $content;// .$dropzoneContent;
    }
}
