<?php
namespace Internetgalerie\IgRender\ViewHelpers\Render;

use Internetgalerie\IgRender\Configuration\FrontendRichtext;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Html\RteHtmlParser;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class ContentBlockViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper
{

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    protected $contentObjectRenderer;

    /**
     * @var \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface
     */
    public $configurationManager;
  
  
    protected $cType;

    protected $RenderWraps = 'all';

    /**
     * @param ContentObjectRenderer $contentObjectRenderer;
     */
    public function injectContentObjectRenderer(ContentObjectRenderer $contentObjectRenderer)
    {
        $this->contentObjectRenderer = $contentObjectRenderer;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface $configurationManager
     */
    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }
    
    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        /* Block eigenschaften*/
        $this->registerArgument('layout', 'integer', 'tt_content layout: Layout', false, '0');
        $this->registerArgument('frameclass', 'string', 'tt_content frame_class: Rahmen', false, 'default');
        $this->registerArgument('sectionframe', 'integer', 'tt_content selectionframe', false, '0');
        $this->registerArgument('iglayout', 'integer', 'Ig-Layout', false, 'csc-default');
        $this->registerArgument('igdesign', 'integer', 'Ig-Design', false, '0');

        $this->registerArgument('spacebeforeclass', 'string', 'Abstand davor', false, '');
        $this->registerArgument('spaceafterclass', 'string', 'Abstand danach', false, 'medium');
    
        $this->registerArgument('CType', 'string', 'Automatische CType erkennung übersteuern', false, '');
        $this->registerArgument('additionalclass', 'string', 'AdditionalClass', false, '');

        $this->registerArgument('renderWraps', 'string', 'renderWraps (all, small, min)', false, '');

        /* Header */
        $this->registerArgument('header', 'string', 'Header', false, '');
        $this->registerArgument('subheader', 'string', 'Subtitle', false, '');
        $this->registerArgument('headerlayout', 'integer', 'Header Titel Layout H1-4', false, '2');
        $this->registerArgument('headerposition', 'integer', 'headerposition', false, '');
        $this->registerArgument('headerlink', 'string', 'headerlink', false, '2');
        $settings = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $this->registerArgument('date', 'DateTime', 'DateTime', false, null);
        /* Text */
        $this->registerArgument('bodytext', 'string', 'bodytext', false, '');
        $this->registerArgument('columnizer', 'boolean', 'columnizer', false, '');

        /* Images */
        $this->registerArgument('images', 'mixed', 'Bilderresourcen', false, '');
        $this->registerArgument('imagewidth', 'string', 'imagewidth', false, '0');
        $this->registerArgument('imageorient', 'integer', 'imageorient', false, '31');
        $this->registerArgument('imagecaption', 'string', 'imagecaption', false, '');
        $this->registerArgument('imagecols', 'integer', 'imagecols', false, '1');
        $this->registerArgument('imagezoom', 'integer', 'imagezoom', false, '1');
        $this->registerArgument('lightboxgalerie', 'string', 'Lightbox Galerie', false, '0');
        $this->registerArgument('imageborder', 'string', 'imageborder', false, '0');
        $this->registerArgument('imagelayout', 'integer', 'imagelayout', false, '1');

        $this->registerArgument('imageeffects', 'text', 'imageeffects', false, '0');
        $this->registerArgument('altText', 'text', 'altText', false, '');
        $this->registerArgument('titleText', 'text', 'titleText', false, '');
        $this->registerArgument('imageaspect', 'text', 'imageaspect', false, '');
        $this->registerArgument('imagelink', 'text', 'image_link', false, '');

        /* File listen*/
        $this->registerArgument('files', 'mixed', 'Fileressourcen', false, '');
        $this->registerArgument('isfilereferenz', 'boolean', 'File Referenz oder ID', false, '1');
        $this->registerArgument('cols', 'string', 'Header', false, '');
        $this->registerArgument('filelinksize', 'boolean', 'filelinksize', false, '');

        /* Accordion */
        $this->registerArgument('isaccordion', 'boolean', 'isaccordion', false, '');
        $this->registerArgument('opendesktop', 'boolean', 'opendesktop', false, '');
        $this->registerArgument('openmobile', 'boolean', 'openmobile', false, '');
    
        /* Links */
        $this->registerArgument('target', 'string', 'Link target', false, '');
    
        $this->registerArgument('galerieSourceCollection', 'boolean', 'Bigger Image Sizes', false, '');
    }






    /**
     * @return ContentObjectRenderer
     */
    protected static function getContentObjectRenderer()
    {
        return GeneralUtility::makeInstance(
            ContentObjectRenderer::class,
            $GLOBALS['TSFE']
        );
    }





  
    protected function getFileReferenceId($source, &$array)
    {
        // array als referenz übergeben (keine kopie bei funktionsaufruf)

        if (is_array($source) || $source instanceof \Traversable) {// wenn array/ oder stoargeobject ode rsonst ne collection, durch die wir loopen können
      foreach ($source as $elem) {// loopen
        $this->getFileReferenceId($elem, $array);
      }
        } elseif ($source instanceof \TYPO3\CMS\Core\Resource\FileReference || $source instanceof \TYPO3\CMS\Extbase\Domain\Model\FileReference || $source instanceof \TYPO3\CMS\Core\Resource\File || $source instanceof \Internetgalerie\IgDatapoolFe\Domain\Model\FileReference) {
            $array[] = $source->getUid();
        } elseif (intval($source) > 0) {
            $array[] = intval($source);
        }
    }

    /**
     * Content Renderer
     *
     * @return string
     */
    public function renderTypoScript($myData)
    {
        $typoscript = $GLOBALS['TSFE']->tmpl->setup['tt_content.'];
        //RTE deaktivieren*/

        unset($typoscript['text.']['20.']['parseFunc']);
        //bodytext
        unset($typoscript['textpic.']['20.']['text.']['20.']['parseFunc']);

        if (!empty($this->arguments['imagecaption'])) {
            //      echo('NOR:'.$this->arguments['imagecaption']);
      
            unset($typoscript['image.']['20.']['caption.']['1.']['1.']);
            unset($typoscript['textpic.']['20.']['caption.']['1.']['1.']);
            $typoscript['image.']['20.']['caption.']['1.']['1.']['value']=$this->arguments['imagecaption'];
            $typoscript['textpic.']['20.']['caption.']['1.']['1.']['value']=$this->arguments['imagecaption'];

            unset($typoscript['image.']['20.']['caption.']['1.']);
            unset($typoscript['textpic.']['20.']['caption.']['1.']);
            $typoscript['image.']['20.']['caption.']['1']= 'TEXT';
            $typoscript['image.']['20.']['caption.']['1.']['value']=$this->arguments['imagecaption'];
            $typoscript['image.']['20.']['caption.']['1.']['wrap'] ='<div class="ig-caption">|</div>';


            /*
    unset($typoscript['image.']['20.']['caption.']['1.']['1.']['parseFunc']);
            unset($typoscript['textpic.']['20.']['caption.']['1.']['1.']['parseFunc']);
            */
        }

        /* RTE deaktivieren */

        /* Eindeutig ID generieren->Wird fÃ¼r die HTML ID ausgabe benÃ¶tigt
         * FIXME(SW): THis basically kills all typoscript render caching functionality ^^
         * iwie von inputs abhänig machen, shortMD5 auf arguments?
         * + möglichkeit, dass es von argument abhängt!
         *
         * $uid = \TYPO3\CMS\Core\Utilities\GeneralUtility::shortMD5(serialize($thsi->argumetns))
         * */

        if ($this->arguments['bodytext']) {
        } else {
            $typoscript['textpic.']['20.']['text.']['20'] = $typoscript['text.']['20'];
            $typoscript['textpic.']['20.']['text.']['20.'] = $typoscript['text.']['20.'];
        }


        //Prüfen ob Referenz oder direkte ID
        unset($typoscript['uploads.']['20.']['references.']);
        if ($this->arguments['isfilereferenz']) {
            $typoscript['uploads.']['20.']['references'] = $this->filesIDs;
        } else {
            $typoscript['uploads.']['20.']['files'] = $this->filesIDs;
        }

        unset($typoscript['image.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']['table']);
        unset($typoscript['image.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']['fieldName']);
        unset($typoscript['image.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']);

        unset($typoscript['image.']['20.']['imgList.']['cObject.']['references.']['table']);
        unset($typoscript['image.']['20.']['imgList.']['cObject.']['references.']['fieldName']);
        unset($typoscript['image.']['20.']['imgList.']['cObject.']['references.']);

        if ($this->arguments['isfilereferenz']) {
            $typoscript['image.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references'] = $this->imagesIDs;
            $typoscript['image.']['20.']['imgList.']['cObject.']['references'] = $this->imagesIDs;
        } else {
            $typoscript['image.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['files'] = $this->imagesIDs;
            $typoscript['image.']['20.']['imgList.']['cObject.']['files'] = $this->imagesIDs;
        }

        if (!empty($this->arguments['imagelink'])) {
            unset($typoscript['image.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['parameter.']['data']);
            unset($typoscript['image.']['20.']['1.']['imageLinkWrap.']['typolink.']['parameter.']['data']);
            unset($typoscript['image.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['parameter.']['data']);

            $typoscript['image.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['image.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['insertData'] = 1;
            $typoscript['image.']['20.']['1.']['imageLinkWrap.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['image.']['20.']['1.']['imageLinkWrap.']['typolink.']['insertData'] = 1;
            $typoscript['image.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['image.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['insertData'] = 1;
        }

        unset($typoscript['textpic.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']['table']);
        unset($typoscript['textpic.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']['fieldName']);
        unset($typoscript['textpic.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references.']);

        unset($typoscript['textpic.']['20.']['imgList.']['cObject.']['references.']['table']);
        unset($typoscript['textpic.']['20.']['imgList.']['cObject.']['references.']['fieldName']);
        unset($typoscript['textpic.']['20.']['imgList.']['cObject.']['references.']);

        if ($this->arguments['isfilereferenz']) {
            $typoscript['textpic.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['references'] = $this->imagesIDs;
            $typoscript['textpic.']['20.']['imgList.']['cObject.']['references'] = $this->imagesIDs;
        } else {
            $typoscript['textpic.']['20.']['preRenderRegisters.']['allImageCaptions.']['cObject.']['files'] = $this->imagesIDs;
            $typoscript['textpic.']['20.']['imgList.']['cObject.']['files'] = $this->imagesIDs;
        }

        if (!empty($this->arguments['imagelink'])) {
            unset($typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['parameter.']['data']);
            unset($typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['typolink.']['parameter.']['data']);
            unset($typoscript['textpic.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['parameter.']['data']);

            $typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['enable.']['ifEmpty.']['typolink.']['insertData'] = 1;
            $typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['textpic.']['20.']['1.']['imageLinkWrap.']['typolink.']['insertData'] = 1;
            $typoscript['textpic.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['parameter.']['field'] = 'image_link';
            $typoscript['textpic.']['20.']['caption.']['1.']['stdWrap.']['typolink.']['insertData'] = 1;
        }

        if (!empty($this->arguments['altText'])) {
            unset($typoscript['image.']['20.']['1.']['altText.']);
            $typoscript['image.']['20.']['1.']['altText'] = $this->arguments['altText'];
        }
        if (!empty($this->arguments['titleText'])) {
            unset($typoscript['image.']['20.']['1.']['titleText.']);
            $typoscript['image.']['20.']['1.']['titleText'] = $this->arguments['titleText'];
        }

        /* IMAGE zu Textpic kopieren->nicht typoscript verwenden! */
        $saveTextpicText = $typoscript['textpic.']['20.']['text.'];
        unset($typoscript['textpic.']['20.']);

        //$typoscript['textpic.']['20']='USER';
        $typoscript['textpic.']['20'] = $typoscript['image.']['20'];
        $typoscript['textpic.']['20.'] = $typoscript['image.']['20.'];
        $typoscript['textpic.']['20.']['text.'] = $saveTextpicText;
        unset($saveTextpicText);

        /* Render Wraps konfigurieren */
        if (!empty($this->arguments['renderWraps'])) {
            $this->RenderWraps = $this->arguments['renderWraps'];
        }


        switch ($this->RenderWraps) {
      default:
      case 'all':
        break;
      case 'small':
        unset($typoscript['stdWrap']);
        unset($typoscript['stdWrap.']);
        break;
      case 'min':
        unset($typoscript['stdWrap']);
        unset($typoscript['stdWrap.']);
        unset($typoscript['image.']['20.']['addClassesCol.']);
        unset($typoscript['image.']['20.']['addClassesImage.']);
        unset($typoscript['image.']['20.']['rendering.']);
        /* Delete all Image-Layouts Wraps*/
        unset($typoscript['image.']['20.']['layout.']);
        $typoscript['image.']['20.']['layout'] = 'TEXT';
        $typoscript['image.']['20.']['layout.']['value'] = '###IMAGES###';
        break;
    }
        /* renders bigger images 600/1920/2550/3840 */
        if ($this->arguments['galerieSourceCollection']) {
            $typoscript['image.']['20.']['1.']['sourceCollection.'] = $GLOBALS['TSFE']->tmpl->setup['lib.']['galerieSourceCollection.']['sourceCollection.'];
        }


        /* Field Variabeln setzten */
        $this->contentObjectRenderer->start($myData);
        //    var_dump($typoscript);

        /*
         * TS Script ausfÃ¼hren
         * @see http://wiki.typo3.org/TypoScript_-_PHP_Interaction
         */
        $out = $this->contentObjectRenderer->cObjGetSingle('CASE', $typoscript);

        /* Ausgeben ;) */
        return $out;
    }

    public function renderFluid($myData, $setup)
    {
        /*    $myData = [
               'data' => $myData
               ];
        */
        $myData['image']=$this->arguments['images'];
        $myData['files']=$this->arguments['files'];
        //$myData[]=$this->arguments['files'];
     $table='tt_content';//'tt_content';
     $contentObjectRenderer = static::getContentObjectRenderer();
        $contentObjectRenderer->start($myData, $table);
     
        //		    $this->contentObjectRenderer->start( ['files' => $this->arguments['images'] ] );
        if (!array_key_exists('tt_content.', $setup)) {
            throw new \TYPO3\CMS\Fluid\Core\ViewHelper\Exception(
                'TypoScript object path "tt_content." does not exist',
                1253191023
            );
        }
        $setup = $setup['tt_content.'];//$GLOBALS['TSFE']->tmpl->setup['tt_content.'];//['image.'];
        if ($myData['image'] || $myData['files']) {
            $setup['image.']['dataProcessing.']['10']='Internetgalerie\IgRender\DataProcessing\FilesProcessor';
            $setup['textmedia.']['dataProcessing.']['10']='Internetgalerie\IgRender\DataProcessing\FilesProcessor';
            $setup['textpic.']['dataProcessing.']['10']='Internetgalerie\IgRender\DataProcessing\FilesProcessor';
            $setup['uploads.']['dataProcessing.']['10']='Internetgalerie\IgRender\DataProcessing\FilesProcessor';
        }

        $CType=$myData['CType'];
        if (!isset($setup[$CType])) {
            throw new \TYPO3\CMS\Fluid\Core\ViewHelper\Exception(
                'No Content Object definition found at TypoScript object path "tt_content.'.$CType.'"',
                1540246570
            );
        }
        return  $contentObjectRenderer->cObjGetSingle($setup[$CType], $setup[$CType . '.'] ?? []);
     

        //return $this->contentObjectRenderer->cObjGetSingle('CASE', $typoscript);
    }

    public function render()
    {
        $uid = uniqid('view');
        $text = '';
        if ($this->arguments['bodytext']) {
            $text = $this->arguments['bodytext'];
        } else {
            $text = $this->renderChildren();
        }


        /* Hole die Bilder UIDs & File UIDs */
        $imagesArray = array();
        $filesArray = array();
        $this->getFileReferenceId($this->arguments['images'], $imagesArray);
        $this->getFileReferenceId($this->arguments['files'], $filesArray);

        $this->imagesIDs = implode(',', $imagesArray);
        $this->filesIDs = implode(',', $filesArray);


    
        /* CType bestimmen wenn nicht angegeben */
        $CType = $this->cType;

        if (!empty($this->arguments['CType'])) {
            $CType = $this->arguments['CType'];
        }

        if (empty($CType)) {
            $CType = 'textpic';

            //$CType = 'textpic';
            if (empty($this->arguments['CType'])) {
                /* Bilder vorhanden */
                if ($this->imagesIDs != '') {
                    if ($text != '') {
                        $CType = 'textpic';
                    } else {
                        $CType = 'image';
                    }
                } elseif (!empty($text)) {
                    $CType = 'text';
                } elseif (!empty($this->filesIDs)) {
                    $CType = 'uploads';
                } elseif (!empty($this->arguments['header'])) {
                    $CType = 'header';
                }
            }
        }
    
        // Ugly fix for unwanted p-Tags because of RTE rendering of the bodytext
        $parseHTML = GeneralUtility::makeInstance(RteHtmlParser::class);
        $parseHTML->init('tt_content:bodytext', $GLOBALS['TSFE']->id);
        $richtextConfigurationProvider = GeneralUtility::makeInstance(FrontendRichtext::class);
        $tcaFieldConf= $GLOBALS['TCA']['tt_content']['columns']['bodytext']['config'];
        //    echo($text);exit(0);
        $text=str_replace('<a ', '[[[a ', $text);
        $text=str_replace('</a>', '[[[/a]]]', $text);

        //echo($text);exit(0);
        $richtextConfiguration = $richtextConfigurationProvider->getConfiguration('tt_content', 'bodytext', $GLOBALS['TSFE']->id, 1, $tcaFieldConf);
        //var_dump($richtextConfiguration);exit(0);
        $text= $parseHTML->RTE_transform(trim($text), [], 'db', $richtextConfiguration);
        $text=str_replace('[[[a ', '<a ', $text);
        $text=str_replace('[[[/a]]]', '</a>', $text);
        /*
*/
        //echo($text);exit(0);
        /* Field Variabeln vorbereiten */
        $myData = array(
      /* Block eigenschaften*/
      'uid' => $uid,
      'CType' => $CType,
      'layout' => $this->arguments['layout'],
      'frame_class' => $this->arguments['frameclass'],
      'space_before_class' => $this->arguments['spacebeforeclass'],
      'space_after_class' => $this->arguments['spaceafterclass'],
      'ig_layout' => $this->arguments['iglayout'],
      'ig_design' => $this->arguments['igdesign'],
      'section_frame' => $this->arguments['sectionframe'],
      'additional_class' => $this->arguments['additionalclass'],

      /* Header */
      'header' => $this->arguments['header'],
      'subheader' => $this->arguments['subheader'],
      'header_layout' => $this->arguments['headerlayout'],
      'header_position' => $this->arguments['headerposition'],
      'header_link' => $this->arguments['headerlink'],
      'date' => $this->arguments['datetime']!==null ? $this->arguments['datetime'] : $this->arguments['date'], // Fluid braucht ein datetime


      /* Text */
      'bodytext' => trim($text),
      //'bodytext' => str_replace(["\r","\n"],"",trim($text)),
      'text-columnizer' => $this->arguments['columnizer'],
      /* Images */
      'imagewidth' => $this->arguments['imagewidth'],
      'imageorient' => $this->arguments['imageorient'],
      'imagecaption' => $this->arguments['imagecaption'],
      'imagecols' => $this->arguments['imagecols'],
      'image_zoom' => $this->arguments['imagezoom'],
      'lightbox_rel' => $this->arguments['lightboxgalerie'],
      'imageborder' => $this->arguments['imageborder'],
      'image_link' => $this->arguments['imagelink'],
      'image_effects' => $this->arguments['imageeffects'],
      'altText' => $this->arguments['altText'],
      'titleText' => $this->arguments['titleText'],
      'image_aspect' => $this->arguments['imageaspect'],
      'cols' => $this->arguments['cols'],
      'imagelayout' => $this->arguments['imagelayout'],
      /* files */
      'filelink_size' => $this->arguments['filelinksize'],

      /* Accordion */
      'ig_accordion_is_accordion' => $this->arguments['isaccordion'],
      'ig_accordion_is_open_desktop' => $this->arguments['opendesktop'],
      'ig_accordion_is_open_mobile' => $this->arguments['openmobile'],
      
      /* Links */
      'target' => $this->arguments['target']
    );




        $setup = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);

        return $this->renderFluid($myData, $setup);
    }
}
