<?php
namespace Internetgalerie\IgRender\ViewHelpers;

/**
 * Extends the translate viewhelper
 *
 * @api
 * @author Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package IgDatapoolFE
 * @subpackage ViewHelpers
 */
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Fluid\Core\ViewHelper\Exception\InvalidVariableException;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

class TranslateViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\TranslateViewHelper
{

  /**
     * Renders a buttons div
     *
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @throws InvalidVariableException
     * @return string
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext): string
    {
        $out = '';

        // 1. try ig_render
        $out = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($arguments['key'], 'ig_render', $arguments['arguments']);
        if ($out) {
            return $out;
        }

        // 2. try current extension
        $currentExtension = $this -> controllerContext -> getRequest() -> getControllerExtensionName();
        $out = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate($arguments['key'], $currentExtension, $arguments['arguments']);
        if ($out) {
            return $out;
        }

        return parent::render();
    }
}
