<?php
namespace Internetgalerie\IgRender\ViewHelpers\Condition\Email;


use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractConditionViewHelper;

/**
 * ### Condition: E-Mail is valid
 *
 * Condition ViewHelper which renders the `then` child if provided
 * Performs a case-sensitive check indicating if $haystack begins with $needle. 
 */
class IsValidViewHelper extends AbstractConditionViewHelper
{
    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('email', 'string', 'email', true);
        $this->registerArgument('trim', 'bool', 'trim email', false, false);
        $this->registerArgument('multiple', 'bool', 'allow comma separated emails (all must be valid)', false, false);
    }

    public static function verdict(array $arguments, RenderingContextInterface $renderingContext)
    {
        if ($arguments['multiple']) {
            $emails = GeneralUtility::trimExplode(',', $arguments['email'], true);
        } else {            
            if ($arguments['trim']) {
                $emails = [trim($arguments['email'])];
            } else {
                $emails = [$arguments['email']];
            }
        }
        if (empty($emails)) {
            return false;
        }
        foreach ($emails as $email) {
            $emailAscii = idn_to_ascii($email);
            if (!filter_var($emailAscii, FILTER_VALIDATE_EMAIL)) {
                return false;
            }
        }
        return true;
    }
}
