<?php

namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\Authentication\FrontendUserAuthentication;

class FrontendUserViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments()
    {
        $this->registerArgument('as', 'string', 'Name for the frontendUser object', false, 'frontendUser');
        $this->registerArgument('property', 'string', 'Property of user object', false);
    }
    public function render(): mixed
    {
        if ($this->arguments['property'] ?? false) {
            $context = GeneralUtility::makeInstance(Context::class);
            $frontendUserProperty = $context->getPropertyFromAspect('frontend.user', $this->arguments['property']) ?? '';
            return $frontendUserProperty;
        }

        $request = $GLOBALS['TYPO3_REQUEST'] ?? null;
        if ($request && $request->getAttribute('frontend.user') instanceof FrontendUserAuthentication) {
            // v12 / v13
            $frontendUserAuthentication = $request->getAttribute('frontend.user');
        } else {
            // v11
            $frontendUserAuthentication = $GLOBALS['TSFE']->fe_user;
        }
        $frontendUser = $frontendUserAuthentication->user;

        $templateVariableContainer = $this->renderingContext->getVariableProvider();
        $templateVariableContainer->add($this->arguments['as'], $frontendUser);
        $output = trim($this->renderChildren());
        $templateVariableContainer->remove($this->arguments['as']);

        return $output;
    }
}
