<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3\CMS\Core\Core\Environment;

/**
 * Menu View Helper
 *
 * @api
 * @author Daniel Abplanalp <da@internetgalerie.ch>, Internetgalerie AG
 * @package IgRender
 * @subpackage ViewHelpers
 */
class MenuViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper
{

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    public $cObj;

    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        /* Block eigenschaften*/
        $this -> registerArgument('lib', 'string', 'Typoscript Path', true, '');
    }


    /**
     * @param int $pageUid Ausgangspunkt / Root page
     * @param array $pageTree
     * @return array
     */
    protected function getPageTree($pageUid = 1, $pageTree = array())
    {
        $this->pageSelect = new t3lib_pageSelect();
        $this->pageSelect->init(true);

        $pageTree = $this->pageSelect->getMenu($pageUid);
        foreach ($pageTree as &$page) {
            $page['subPages'] = $this->getPageTree($page['uid'], $pageTree);
        }

        return $pageTree;
    }


    /**
     * Menu/Typo3script rendern und Cachen
     *
     * @return string
     */
    public function render()
    {
        //$ts_path = explode('.',$this->arguments['typoscript'];

        $lib = $this->arguments['lib'];
        $ts = $GLOBALS['TSFE']->tmpl->setup['lib.'][$lib .'.'];
      
        $mp = $GLOBALS['TSFE']->MP;
        if ($mp) {
            $mp_array=explode('-', $mp);
            $mp=$mp_array[0];
        }
        //TODO sinnvoll? md5($GLOBALS['TSFE']->tmpl->setup['lib.'][$this->arguments['lib']]) fuer excludeUidList  etc.
     
        // Usergruppen beruecksichtigen

        $usergroup = explode(',', $GLOBALS['TSFE']->fe_user->user['usergroup']);
        sort($usergroup);
        $groups = implode('_', $usergroup);
        if ($groups) {
            $groups = '-' . $groups;
        }
        //echo('groups ='. $groups .'<br />');
        $lang = $GLOBALS['TSFE']->config['config']['language'];

        //$lang = $GLOBALS['TSFE']->sys_language_uid;

        $cache_file = Environment::getPublicPath() . '/'. 'typo3temp/ig_render/'.$lib. '-' . $lang . $groups .'.html';
        if (file_exists($cache_file)) {
            $content =  file_get_contents($cache_file);
        } else {
            $content = str_replace("\r", "", $this->cObj->cObjGetSingle($GLOBALS['TSFE']->tmpl->setup['lib.'][$this->arguments['lib']], $ts));
            // ###CLASSES### reinbescheissen - falls nicht über TS
            $content = str_replace("\t", '', $content);
            $content = str_replace('active ', '', $content);
            $content = str_replace('currentSub ', '', $content);
            $content = str_replace('activeSub ', '', $content);
            $content = str_replace('current ', '', $content);
            $content = str_replace('active"', '"', $content);
            $content = str_replace('currentSub"', '"', $content);
            $content = str_replace('activeSub"', '"', $content);
            $content = str_replace('current"', '"', $content);
            $content = str_replace(' active', '', $content);
            $content = str_replace(' currentSub', '', $content);
            $content = str_replace(' current', '', $content);
            $content = str_replace(' activeSub', '', $content);
            $content = str_replace('&#32;doktype-', '###CLASSES### doktype-', $content);
            \TYPO3\CMS\Core\Utility\GeneralUtility::writeFileToTypo3tempDir($cache_file, $content);
        }
        // CUR
      $content = str_replace('hasChild item-'. $GLOBALS['TSFE']->id .'###CLASSES##', 'active activeSub hasChild item-'. $GLOBALS['TSFE']->id .' active current', $content); // currentSub

      //$content = str_replace('item-'. $GLOBALS['TSFE']->id .'###CLASSES##', 'item-'. $GLOBALS['TSFE']->id .' active current', $content );

        // ist das noetig ? - Bei aktivem Link Klasse in  A tag setzen
        $pos_cur = strpos($content, 'item-'. $GLOBALS['TSFE']->id .'###CLASSES###');
        if ($pos_cur>0) {
            $replace_length = strlen('item-'. $GLOBALS['TSFE']->id .'###CLASSES###');
            $pos_cur_class = strpos($content, 'class="normal"', $pos_cur);
            $content = substr($content, 0, $pos_cur) .'item-'. $GLOBALS['TSFE']->id .' active current' . substr($content, $pos_cur + $replace_length, $pos_cur_class-$pos_cur -$replace_length+7) .'active'.substr($content, $pos_cur_class+13);
        }

        //echo('current='. $GLOBALS['TSFE']->id. ',<br />');
        // rootline
        $rootline = $GLOBALS['TSFE']->sys_page->getRootLine($GLOBALS['TSFE']->id, $GLOBALS['TSFE']->MP);
        foreach ($rootline as $r) {
            //echo( $r['uid'] . ',<br />');
    $content = str_replace('hasChild item-'. $r['uid'] .'###CLASSES###', ' active activeSub hasChild item-'. $r['uid'] .' active current', $content); // currentSub
    $content = str_replace('item-'. $r['uid'] .'###CLASSES###', 'item-'. $r['uid'] .' active', $content);
        }

        $content = str_replace('###CLASSES###', '', $content);
      


        return $content;
        /*

    // oder doch manuell selbst ?
    $this->pageSelect = new t3lib_pageSelect();
    $this->pageSelect->init(TRUE);

    $pageTree = $this->pageSelect->getMenu($pageUid);
    foreach($pageTree as &$page) {
    $page['subPages'] = $this->getPageTree($page['uid'], $pageTree);
    }


         */
    }
}
