<?php
namespace Internetgalerie\IgRender\ViewHelpers\Render;

/**
 * View Helper Text
 *
 * @api
 * @author Markus Baumgartner <mb@stylesheep.ch>, Internetgalerie AG
 * @package IgDatapoolFE
 * @subpackage ViewHelpers
 */
class GalerieViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper
{

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    public $cObj;

    /**
     * Initialize the arguments.
     *
     * @return void
     * @api
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        /* Block eigenschaften*/
        $this -> registerArgument('layout', 'integer', 'Ig-Design Wert', false, 'csc-default');
        $this -> registerArgument('iglayout', 'integer', 'Ig-Layout Wert', false, '98');
        $this -> registerArgument('sectionframe', 'integer', 'Ig-Design Wert', false, '0');
        $this -> registerArgument('igdesign', 'integer', 'Ig-Design Wert', false, '0');
        $this -> registerArgument('CType', 'string', 'Ig-Design Wert', false, '');

        $this -> registerArgument('type', 'string', 'Ig-Design Wert', false, 'grid');
        $this -> registerArgument('id', 'string', 'ID', false, '');

        /* Header */
        $this -> registerArgument('header', 'string', 'Header', false, '');
        $this -> registerArgument('headerlayout', 'integer', 'Header Titel Layout H1-4', false, '2');
        $this -> registerArgument('headerposition', 'integer', 'headerposition', false, '');
        $this -> registerArgument('headerlink', 'string', 'headerlink', false, '2');

        $this -> registerArgument('textalign', 'string', 'block-left', false, 'block-left');
        $this -> registerArgument('vertical', 'string', 'child', false, 'ig-child-top');

        /* Galerie Argumente */
        /*$out .= '<div class="ig-galerie-holder blenden" data-slideshowtime="6"
         * data-animationdnd="0" data-animationtime="3">';*/
        $this -> registerArgument('animation', 'string', 'child', false, 'blenden');
        $this -> registerArgument('slideshowtime', 'integer', 'child', false, '6');
        $this -> registerArgument('animationdnd', 'integer', 'child', false, '0');
        $this -> registerArgument('animationtime', 'integer', 'child', false, '3');
        $this -> registerArgument('mode', 'string', 'child', false, 'highAspectMode');
        $this -> registerArgument('slideshow', 'integer', 'child', false, '');
        $this -> registerArgument('aspectratio', 'string', 'child', false, '');
        $this -> registerArgument('dotts', 'integer', 'child', false, '1');
        $this -> registerArgument('nav', 'integer', 'child', false, '1');
        $this -> registerArgument('noSwipe', 'integer', 'child', false, '1');
        $this -> registerArgument('darkIcons', 'integer', 'child', false, '0');
    }

    public function render()
    {
        /* Stdheader Typoscript laden*/
        $typoscript = $GLOBALS['TSFE'] -> tmpl -> setup['lib.']["stdheader."];

        // Add dark-icons class when dark icons should be used.
        $darkIconClass = '';
        if ($this->arguments["darkIcons"]) {
            $darkIconClass = 'dark-icons';
        }

        /**
         *@see http://wiki.typo3.org/TypoScript_-_PHP_Interaction
         */
        /* Eindeutig ID generieren -> Wird für die HTML ID ausgabe benötigt */
        $uid = uniqid("view");

        $CType = "gridelements_pi1";
        /* Field Variabeln vorbereiten */
        $myData = array(
        /* Block eigenschaften*/
        "uid" => $uid, "CType" => $CType, "layout" => $this -> arguments["layout"], "iglayout" => $this -> arguments["iglayout"], "ig_design" => $this -> arguments["igdesign"], "section_frame" => $this -> arguments["sectionframe"],

        /* Header */
        "header" => $this -> arguments["header"], 'header_layout' => $this -> arguments["headerlayout"], 'header_position' => $this -> arguments["headerposition"], 'header_link' => $this -> arguments["headerlink"], );

        /* Field Variabeln setzten */
        $this -> cObj -> start($myData);
        if (intval($this -> arguments["iglayout"]) > 0) {
            $layout = "ig-layout-" . intval($this -> arguments["iglayout"]);
        } else {
            $layout = "csc-default";
        }
        $out .= '<div id="col' . $uid . '" class="' . $layout . ' gridelements_pi1 ig-design-' . $this -> arguments["sectionframe"] . '" >';

        /* TS Script ausführen */
        $out .= $this -> cObj -> cObjGetSingle('COA', $typoscript);

        switch ($this -> arguments["type"]) {
            case galerie:
                if ($this -> arguments["slideshow"] == 1) {
                    $slideshow = 'slideshowstart';
                } else {
                    $slideshow = 'noslideshowstart';
                }
                $out .= '<div id="' . $this -> arguments["id"] . '" class="ym-grid ig-galerie ' . $darkIconClass . ' inactive center ' . $slideshow . ' ' . $this -> arguments["mode"] . '">';

                if ($this -> arguments["dotts"] == 1) {
                    $out .= '<span class="ig-galerie-extendNav dotts" data-style="dotts"></span>';
                }
                if ($this -> arguments["nav"] == 1) {
                    $out .= '<span class="ig-galerie-handler prev" data-move="prev"><span>zurück</span></span><span class="ig-galerie-handler next" data-move="next"><span>weiter</span></span>';
                }
                $out .= '<div class="ig-galerie-holder ' . $this -> arguments["animation"] . '" data-slideshowtime="' . $this -> arguments["slideshowtime"] . '" data-animationdnd="' . $this -> arguments["animationdnd"] . '" data-animationtime="' . $this -> arguments["animationtime"] . '" data-swipe="' . $this -> arguments["noSwipe"] . '">';

                $out .= $this -> renderChildren();

                $out .= '</div></div>';
                break;
            case grid:
            default:
                $out .= '<div class="ym-grid no-equalize ig-child-top block-left">';

                $out .= preg_replace("/(\t\n\r\s)/", "", $this -> renderChildren());

                $out .= '</div>';
                break;
        }
        $out .= '</div>';

        //* Ausgeben ;) */
        return $out;
    }
}
