"use strict";

document.addEventListener("DOMContentLoaded", function() {
    var tabsMenuItems = document.querySelectorAll('.ig-tabs-menu-item a');
    
    tabsMenuItems.forEach(function(tabMenuItem) {
        tabMenuItem.addEventListener('click', function(event) {
            event.preventDefault();
            var tabName = this.parentElement.getAttribute('data-tab-name');
            var tabs = this.closest('.ig-tabs');

            var tabMenuItems = tabs.querySelectorAll('.ig-tabs-menu .ig-tabs-menu-item');
            tabMenuItems.forEach(function(menuItem) {
                if (menuItem.getAttribute('data-tab-name') === tabName) {
                    menuItem.classList.add('ig-tabs-menu-item-active');
                } else {
                    menuItem.classList.remove('ig-tabs-menu-item-active');
                }
            });

            var tabContents = tabs.querySelectorAll('.ig-tabs-container .ig-tabs-tab');
            tabContents.forEach(function(tabContent) {
                if (tabContent.getAttribute('data-tab-name') === tabName) {
                    tabContent.style.display = 'block';
                } else {
                    tabContent.style.display = 'none';
                }
            });
        });
    });
});