<?php
namespace Internetgalerie\IgRender\ViewHelpers\Format;


use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

class NumberViewHelper extends \Internetgalerie\IgCoreViewhelpers\ViewHelpers\Format\NumberViewHelper
{
    use CompileWithRenderStatic;

    /**
     * Output is escaped already. We must not escape children, to avoid double encoding.
     *
     * @var bool
     */
    protected $escapeChildren = false;

    /**
     * Initialize arguments.
     *
     * @throws \TYPO3Fluid\Fluid\Core\ViewHelper\Exception
     */
    public function initializeArguments(): void
    {

        // numeric locale is not set by the core because of problems with floats, set it here manually for number format:
        $currentLocale = setlocale(LC_MONETARY, 0);
        $oldLocale = setlocale(LC_NUMERIC, 0);
        setlocale(LC_NUMERIC, $currentLocale);
        $localeInfo = localeconv();
        setlocale(LC_NUMERIC, $oldLocale);
        
        $this->registerArgument('decimals', 'int', 'The number of digits after the decimal point', false, '2');
        $this->registerArgument('decimalSeparator', 'string', 'The decimal point character', false, $localeInfo['decimal_point']);
        $this->registerArgument('thousandsSeparator', 'string', 'The character for grouping the thousand digits', false, $localeInfo['thousands_sep']);
    }
}
