<?php
namespace Internetgalerie\IgRender\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * MB: extended the for view helper so that it trims its content. for use with inline-block
 * Same usage
 * @see line 52
 */
class ForViewHelper extends \TYPO3Fluid\Fluid\ViewHelpers\ForViewHelper
{
    /**
     * @param array $arguments
     * @param \Closure $renderChildrenClosure
     * @param RenderingContextInterface $renderingContext
     * @return string
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     */
    public static function renderStatic(array $arguments, \Closure $renderChildrenClosure, RenderingContextInterface $renderingContext)
    {
        $templateVariableContainer = $renderingContext->getVariableProvider();
        if ($arguments['each'] === null) {
            return '';
        }
        if (is_object($arguments['each']) && !$arguments['each'] instanceof \Traversable) {
            throw new \TYPO3\CMS\Fluid\Core\ViewHelper\Exception('ForViewHelper only supports arrays and objects implementing \Traversable interface', 1248728393);
        }

        if ($arguments['reverse'] === true) {
            // array_reverse only supports arrays
            if (is_object($arguments['each'])) {
                $arguments['each'] = iterator_to_array($arguments['each']);
            }
            $arguments['each'] = array_reverse($arguments['each']);
        }
        $iterationData = array('index' => 0, 'cycle' => 1, 'total' => count($arguments['each']));

        $output = '';
        foreach ($arguments['each'] as $keyValue => $singleElement) {
            $templateVariableContainer -> add($arguments['as'], $singleElement);
            if ($arguments['key'] !== '') {
                $templateVariableContainer -> add($arguments['key'], $keyValue);
            }
            if ($arguments['iteration'] !== null) {
                $iterationData['isFirst'] = $iterationData['cycle'] === 1;
                $iterationData['isLast'] = $iterationData['cycle'] === $iterationData['total'];
                $iterationData['isEven'] = $iterationData['cycle'] % 2 === 0;
                $iterationData['isOdd'] = !$iterationData['isEven'];
                $templateVariableContainer -> add($arguments['iteration'], $iterationData);
                $iterationData['index']++;
                $iterationData['cycle']++;
            }

            // EDIT MB:
            $output .= trim($renderChildrenClosure());
            // END EDIT MB

            $templateVariableContainer -> remove($arguments['as']);
            if ($arguments['key'] !== '') {
                $templateVariableContainer -> remove($arguments['key']);
            }
            if ($arguments['iteration'] !== null) {
                $templateVariableContainer -> remove($arguments['iteration']);
            }
        }
        return $output;
    }
}
