<?php
namespace Internetgalerie\IgRender\ViewHelpers\Format;

use Internetgalerie\IgsCrm\Domain\Model\Contact;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class TimeViewHelper extends AbstractViewHelper
{

    /**
     * Initialize arguments
     */
    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('time', 'int', 'Zeit in Sekunden', false);
        $this->registerArgument('leadingZero', 'bool', 'Add leading zero to hours', false, false);
    }

    /**
     * Content Renderer
     * @return string
     */
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        if (isset($arguments['time'])) {
            $time = (int)$arguments['time'];
        } else {
            $time = (int)$renderChildrenClosure();
        }

        if ($time < 0) {
            $sign = '-';
            $time = abs($time);
        } else {
            $sign = '';
        }

        $s = $time % 60;
        $timeM = ($time - $s)/60;
        $m = $timeM % 60;
        $h = ($timeM - $m) / 60;
        $format = $arguments['leadingZero'] ? '%02d:%02d:%02d' : '%d:%02d:%02d';
        return $sign . sprintf($format, $h, $m, $s);
    }
}