<?php
namespace Internetgalerie\IgRender\Utility;


class UnCacheUtility implements \TYPO3\CMS\Core\SingletonInterface
{


    /**
     * Register the class as INTincScript, must have function callUserFunction
     *
     * @param class $cObjClass callUserFunction
     */
    public function registerClass($cObjClass, $postUserFunc, $arguments)
    {
        $substKey = 'INT_SCRIPT.' . $GLOBALS['TSFE']->uniqueHash();
        $content = '<!--' . $substKey . '-->';
        $GLOBALS['TSFE']->config['INTincScript'][$substKey] = [
            'type' => 'POSTUSERFUNC',
            'cObj' => serialize($cObjClass),
            'postUserFunc' => $postUserFunc,
            'conf' => [
                'arguments' => $arguments
            ],
            'content' => $content
        ];
        return $content;
    }

    public function registerFunction($postUserFunc, $arguments)
    {
        $cObjClass=new \Internetgalerie\IgRender\Helpers\UnCacheUtilityCallUserFunction();
        return $this->registerClass($cObjClass, $postUserFunc, $arguments);
    }
    public function registerAspect(string $name, string $property, $default = null)
    {
        $cObjClass=new \Internetgalerie\IgRender\Helpers\UnCacheUtilityCallAspect();
        //$cObjClass->set($name, $property, $default);
        $arguments=[
            'name' => $name,
            'property' => $property,
            'default' => $default
        ];
        return $this->registerClass($cObjClass, $postUserFunc, $arguments);
    }
}
